﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/medialive/MediaLive_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaLive {
namespace Model {

/**
 * Placeholder documentation for MultiplexProgramSummary<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/MultiplexProgramSummary">AWS
 * API Reference</a></p>
 */
class MultiplexProgramSummary {
 public:
  AWS_MEDIALIVE_API MultiplexProgramSummary() = default;
  AWS_MEDIALIVE_API MultiplexProgramSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API MultiplexProgramSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * The MediaLive Channel associated with the program.
   */
  inline const Aws::String& GetChannelId() const { return m_channelId; }
  inline bool ChannelIdHasBeenSet() const { return m_channelIdHasBeenSet; }
  template <typename ChannelIdT = Aws::String>
  void SetChannelId(ChannelIdT&& value) {
    m_channelIdHasBeenSet = true;
    m_channelId = std::forward<ChannelIdT>(value);
  }
  template <typename ChannelIdT = Aws::String>
  MultiplexProgramSummary& WithChannelId(ChannelIdT&& value) {
    SetChannelId(std::forward<ChannelIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The name of the multiplex program.
   */
  inline const Aws::String& GetProgramName() const { return m_programName; }
  inline bool ProgramNameHasBeenSet() const { return m_programNameHasBeenSet; }
  template <typename ProgramNameT = Aws::String>
  void SetProgramName(ProgramNameT&& value) {
    m_programNameHasBeenSet = true;
    m_programName = std::forward<ProgramNameT>(value);
  }
  template <typename ProgramNameT = Aws::String>
  MultiplexProgramSummary& WithProgramName(ProgramNameT&& value) {
    SetProgramName(std::forward<ProgramNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_channelId;

  Aws::String m_programName;
  bool m_channelIdHasBeenSet = false;
  bool m_programNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
