# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_cargo_spellcheck_global_optspecs
	string join \n c/cfg= v/verbose q/quiet r/recursive checkers= s/skip-readme d/dev-comments j/jobs= m/code= f/fix h/help V/version
end

function __fish_cargo_spellcheck_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_cargo_spellcheck_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_cargo_spellcheck_using_subcommand
	set -l cmd (__fish_cargo_spellcheck_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s c -l cfg -d 'Provide a configuration' -r -F
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -l checkers -d 'Execute the given subset of checkers' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s j -l jobs -d 'The number of worker threads to spawn for the actual processing text' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s m -l code -d 'Return code of the application if spelling mistakes were found' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s v -l verbose -d 'Increase logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s q -l quiet -d 'Decrease logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s r -l recursive -d 'Recurse based on the current directory, or all given argument paths, and also declared modules in rust files'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s s -l skip-readme -d 'Do not check the referenced key `readme=` or default `README.md`'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s d -l dev-comments -d 'Also check developer comments besides documentation comments'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s f -l fix -d 'Alt for `cargo spellcheck fix` [deprecated]'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s h -l help -d 'Print help'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -s V -l version -d 'Print version'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -a "check" -d 'Only show check errors, but do not request user input'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -a "fix" -d 'Interactively choose from checker provided suggestions'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -a "reflow" -d 'Reflow doc comments, so they adhere to a given maximum column width'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -a "config" -d 'Print the config being in use, default config if none'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -a "list-files" -d 'List all files in depth-first-sorted-order in which they would be checked'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -a "completions" -d 'Print completions'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -l checkers -d 'Execute the given subset of checkers' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s j -l jobs -d 'The number of worker threads to spawn for the actual processing text' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s m -l code -d 'Return code of the application if spelling mistakes were found' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s c -l cfg -d 'Provide a configuration' -r -F
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s r -l recursive -d 'Recurse based on the current directory, or all given argument paths, and also declared modules in rust files'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s s -l skip-readme -d 'Do not check the referenced key `readme=` or default `README.md`'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s d -l dev-comments -d 'Also check developer comments besides documentation comments'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s v -l verbose -d 'Increase logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s q -l quiet -d 'Decrease logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand check" -s h -l help -d 'Print help'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -l checkers -d 'Execute the given subset of checkers' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s j -l jobs -d 'The number of worker threads to spawn for the actual processing text' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s m -l code -d 'Return code of the application if spelling mistakes were found' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s c -l cfg -d 'Provide a configuration' -r -F
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s r -l recursive -d 'Recurse based on the current directory, or all given argument paths, and also declared modules in rust files'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s s -l skip-readme -d 'Do not check the referenced key `readme=` or default `README.md`'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s d -l dev-comments -d 'Also check developer comments besides documentation comments'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s v -l verbose -d 'Increase logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s q -l quiet -d 'Decrease logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand fix" -s h -l help -d 'Print help'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -l checkers -d 'Execute the given subset of checkers' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s j -l jobs -d 'The number of worker threads to spawn for the actual processing text' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s m -l code -d 'Return code of the application if spelling mistakes were found' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s c -l cfg -d 'Provide a configuration' -r -F
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s r -l recursive -d 'Recurse based on the current directory, or all given argument paths, and also declared modules in rust files'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s s -l skip-readme -d 'Do not check the referenced key `readme=` or default `README.md`'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s d -l dev-comments -d 'Also check developer comments besides documentation comments'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s v -l verbose -d 'Increase logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s q -l quiet -d 'Decrease logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand reflow" -s h -l help -d 'Print help'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -l filter -d 'Limit checkers to enable in the generated configuration' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -s c -l cfg -d 'Provide a configuration' -r -F
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -s u -l user -d 'Write to the default user configuration file path'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -s o -l overwrite -d 'Force overwrite an existing user config'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -s s -l stdout -d 'Write to `stdout`'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -s v -l verbose -d 'Increase logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -s q -l quiet -d 'Decrease logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand config" -s h -l help -d 'Print help'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand list-files" -s c -l cfg -d 'Provide a configuration' -r -F
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand list-files" -s r -l recursive -d 'Recurse down directories and module declaration derived paths'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand list-files" -s s -l skip-readme -d 'Do not check the referenced key `readme=` or default `README.md`'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand list-files" -s v -l verbose -d 'Increase logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand list-files" -s q -l quiet -d 'Decrease logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand list-files" -s h -l help -d 'Print help'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand completions" -l shell -d 'Provide the `shell` for which to generate the completion script' -r
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand completions" -s c -l cfg -d 'Provide a configuration' -r -F
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand completions" -s v -l verbose -d 'Increase logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand completions" -s q -l quiet -d 'Decrease logging verbosity'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand completions" -s h -l help -d 'Print help'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand help; and not __fish_seen_subcommand_from check fix reflow config list-files completions help" -f -a "check" -d 'Only show check errors, but do not request user input'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand help; and not __fish_seen_subcommand_from check fix reflow config list-files completions help" -f -a "fix" -d 'Interactively choose from checker provided suggestions'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand help; and not __fish_seen_subcommand_from check fix reflow config list-files completions help" -f -a "reflow" -d 'Reflow doc comments, so they adhere to a given maximum column width'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand help; and not __fish_seen_subcommand_from check fix reflow config list-files completions help" -f -a "config" -d 'Print the config being in use, default config if none'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand help; and not __fish_seen_subcommand_from check fix reflow config list-files completions help" -f -a "list-files" -d 'List all files in depth-first-sorted-order in which they would be checked'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand help; and not __fish_seen_subcommand_from check fix reflow config list-files completions help" -f -a "completions" -d 'Print completions'
complete -c cargo-spellcheck -n "__fish_cargo_spellcheck_using_subcommand help; and not __fish_seen_subcommand_from check fix reflow config list-files completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
[?25h