/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class StatusLineContributionItemEx
extends ContributionItem {
    private CLabel label;
    private String text = "";
    private String toolTip = "";
    private Runnable doubleClickListener;
    private int maxWidth = 0;

    public StatusLineContributionItemEx(String id) {
        super(id);
        this.setVisible(false);
    }

    public void fill(Composite parent) {
        Label sep = new Label(parent, 2);
        this.label = new CLabel(parent, 32);
        this.label.setText(this.text);
        if (this.toolTip != null) {
            this.label.setToolTipText(this.toolTip);
        }
        if (this.doubleClickListener != null) {
            this.label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    StatusLineContributionItemEx.this.doubleClickListener.run();
                }
            });
        }
        Point preferredSize = this.label.computeSize(-1, -1);
        int widthHint = Math.max(this.maxWidth, preferredSize.x);
        int heightHint = preferredSize.y;
        this.maxWidth = widthHint;
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.widthHint = widthHint;
        this.label.setLayoutData((Object)data);
        data = new StatusLineLayoutData();
        data.heightHint = heightHint;
        sep.setLayoutData((Object)data);
    }

    public void setDoubleClickListener(Runnable doubleClickListener) {
        this.doubleClickListener = doubleClickListener;
    }

    public void setText(String text) {
        Assert.isNotNull((Object)text);
        this.text = LegacyActionTools.escapeMnemonics((String)text);
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setText(this.text);
        }
        this.updateUI();
    }

    private void updateUI() {
        this.setVisible(true);
        IContributionManager contributionManager = this.getParent();
        if (contributionManager != null) {
            contributionManager.update(true);
        }
    }

    public void setToolTip(String text) {
        this.toolTip = text;
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setToolTipText(this.toolTip);
        }
        this.updateUI();
    }
}

