/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LocalCacheProgressMonitor;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class SQLSearchUtils {
    private static final Log log = Log.getLog(SQLSearchUtils.class);

    @Nullable
    public static DBSObject findObjectByFQN(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @Nullable DBCExecutionContext executionContext, @NotNull List<String> nameList, boolean useAssistant, @NotNull SQLIdentifierDetector identifierDetector) {
        return SQLSearchUtils.getFirstIfPresented(SQLSearchUtils.findObjectsByFQN(monitor, objectContainer, executionContext, nameList, useAssistant, identifierDetector, false, false));
    }

    @Nullable
    public static DBSObject findObjectByFQN(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @Nullable SQLCompletionRequest request, @NotNull List<String> nameList) {
        return SQLSearchUtils.getFirstIfPresented(SQLSearchUtils.findObjectsByFQN(monitor, objectContainer, request.getContext().getExecutionContext(), nameList, !request.isSimpleMode(), request.getWordDetector(), request.getContext().isSearchGlobally(), false));
    }

    @Nullable
    private static <T> T getFirstIfPresented(@Nullable List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.getFirst();
    }

    @NotNull
    public static List<? extends DBSObject> findObjectsByFQN(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @Nullable DBCExecutionContext executionContext, @NotNull List<String> nameList, boolean useAssistant, @NotNull SQLIdentifierDetector identifierDetector, boolean anyObject) {
        return SQLSearchUtils.findObjectsByFQN(monitor, objectContainer, executionContext, nameList, useAssistant, identifierDetector, false, anyObject);
    }

    @NotNull
    public static List<? extends DBSObject> findObjectsByFQN(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @Nullable DBCExecutionContext executionContext, @NotNull List<String> nameList, boolean useAssistant, @NotNull SQLIdentifierDetector identifierDetector, boolean isGlobalSearch, boolean anyObject) {
        DBRProgressMonitor mdMonitor;
        DBPDataSource dataSource;
        if (nameList.isEmpty()) {
            return Collections.emptyList();
        }
        DBPDataSource dBPDataSource = dataSource = objectContainer == null ? null : objectContainer.getDataSource();
        if (executionContext == null && dataSource != null) {
            executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true);
        }
        if (dataSource == null && executionContext != null) {
            dataSource = executionContext.getDataSource();
        }
        if (dataSource == null) {
            return Collections.emptyList();
        }
        Object object = mdMonitor = dataSource.getContainer().isExtraMetadataReadEnabled() ? monitor : new LocalCacheProgressMonitor(monitor);
        if (!mdMonitor.isForceCacheUsage()) {
            ArrayList<String> unquotedNames = new ArrayList<String>(nameList.size());
            for (String name : nameList) {
                unquotedNames.add(DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)name));
            }
            List<? extends DBSObject> result = SQLSearchUtils.findObjectsByPath(mdMonitor, executionContext, objectContainer, unquotedNames, identifierDetector, useAssistant, isGlobalSearch, anyObject);
            if (!result.isEmpty()) {
                return result;
            }
        }
        ArrayList<String> transformedNameList = new ArrayList<String>(nameList);
        int i = 0;
        while (i < nameList.size()) {
            String name = nameList.get(i);
            String unquotedName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)name);
            name = !unquotedName.equals(name) ? unquotedName : DBObjectNameCaseTransformer.transformName((DBPDataSource)objectContainer.getDataSource(), (String)name);
            transformedNameList.set(i, name);
            ++i;
        }
        return SQLSearchUtils.findObjectsByPath(mdMonitor, executionContext, objectContainer, transformedNameList, identifierDetector, useAssistant, isGlobalSearch, anyObject);
    }

    @Nullable
    public static DBSObject findObjectByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer objectContainer, @NotNull List<String> nameList, @NotNull SQLIdentifierDetector identifierDetector, boolean useAssistant) {
        return SQLSearchUtils.getFirstIfPresented(SQLSearchUtils.findObjectsByPath(monitor, executionContext, objectContainer, nameList, identifierDetector, useAssistant, false, false));
    }

    @NotNull
    public static List<? extends DBSObject> findObjectsByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer sc, @NotNull List<String> nameList, @NotNull SQLIdentifierDetector identifierDetector, boolean useAssistant, boolean isGlobalSearch, boolean anyObject) {
        try {
            DBCExecutionContextDefaults contextDefaults;
            if (!nameList.isEmpty() && (contextDefaults = executionContext.getContextDefaults()) != null) {
                DBSCatalog catalog;
                List<? extends DBSProcedure> objs;
                DBSSchema defaultSchema;
                if (nameList.size() == 1 && (defaultSchema = contextDefaults.getDefaultSchema()) != null) {
                    DBSProcedureContainer procsContainer;
                    DBSObject entity = defaultSchema.getChild(monitor, nameList.get(0));
                    if (entity != null) {
                        return List.of(entity);
                    }
                    if (anyObject && defaultSchema instanceof DBSProcedureContainer && (objs = SQLSearchUtils.findProcedures(monitor, procsContainer = (DBSProcedureContainer)defaultSchema, nameList.get(0))).size() > 0) {
                        return objs;
                    }
                }
                if (!nameList.isEmpty() && (catalog = contextDefaults.getDefaultCatalog()) != null) {
                    DBSProcedureContainer childProcsContainer;
                    DBSObject childObject = catalog.getChild(monitor, nameList.get(0));
                    if (childObject != null) {
                        if (nameList.size() == 1) {
                            return List.of(childObject);
                        }
                        if (nameList.size() == 2) {
                            DBSProcedureContainer childProcsContainer2;
                            List<? extends DBSProcedure> objs2;
                            DBSObjectContainer schema;
                            DBSObject entity;
                            if (childObject instanceof DBSObjectContainer && (entity = (schema = (DBSObjectContainer)childObject).getChild(monitor, nameList.get(1))) != null) {
                                return List.of(entity);
                            }
                            if (anyObject && childObject instanceof DBSProcedureContainer && (objs2 = SQLSearchUtils.findProcedures(monitor, childProcsContainer2 = (DBSProcedureContainer)childObject, nameList.get(1))).size() > 0) {
                                return objs2;
                            }
                        }
                    }
                    if (anyObject && catalog instanceof DBSProcedureContainer && !(objs = SQLSearchUtils.findProcedures(monitor, childProcsContainer = (DBSProcedureContainer)catalog, nameList.get(0))).isEmpty()) {
                        return objs;
                    }
                }
            }
            List<? extends DBSObject> childObject = null;
            while (childObject == null) {
                childObject = SQLSearchUtils.findNestedObjects(monitor, executionContext, sc, nameList, anyObject);
                if (!childObject.isEmpty()) continue;
                DBSObjectContainer parentSc = (DBSObjectContainer)DBUtils.getParentAdapter(DBSObjectContainer.class, (DBSObject)sc);
                if (parentSc == null) break;
                sc = parentSc;
            }
            if (childObject.isEmpty() && nameList.size() <= 1) {
                DBSStructureAssistant structureAssistant;
                if (useAssistant && !monitor.isForceCacheUsage() && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null) {
                    String objectNameMask = nameList.get(0);
                    DBSStructureAssistant.ObjectsSearchParams params = new DBSStructureAssistant.ObjectsSearchParams(structureAssistant.getAutoCompleteObjectTypes(), identifierDetector.removeQuotes(objectNameMask));
                    params.setParentObject((DBSObject)sc);
                    params.setCaseSensitive(identifierDetector.isQuoted(objectNameMask));
                    params.setMaxResults(2);
                    params.setGlobalSearch(isGlobalSearch);
                    List tables = structureAssistant.findObjectsByMask(monitor, executionContext, params);
                    if (!tables.isEmpty()) {
                        return List.of(((DBSObjectReference)tables.iterator().next()).resolveObject(monitor));
                    }
                }
                return Collections.emptyList();
            }
            return childObject;
        }
        catch (DBException e) {
            log.error((Object)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    public static List<? extends DBSObject> findNestedObjects(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer parent, @NotNull List<String> names, boolean anyObject) throws DBException {
        int i = 0;
        while (i < names.size()) {
            DBSObjectContainer oc;
            if (monitor.isCanceled()) break;
            String childName = names.get(i);
            parent.cacheStructure(monitor, 1);
            DBSObject child = parent.getChild(monitor, childName);
            if (!DBStructUtils.isConnectedContainer((DBPObject)child)) {
                child = null;
            }
            if (anyObject && child == null && parent instanceof DBSProcedureContainer) {
                List<? extends DBSProcedure> objs;
                DBSProcedureContainer procsContainer = (DBSProcedureContainer)parent;
                if (parent.getDataSource().getInfo().supportsStoredCode() && (objs = SQLSearchUtils.findProcedures(monitor, procsContainer, childName)).size() > 0) {
                    return objs;
                }
            }
            if (child == null) break;
            if (i == names.size() - 1) {
                return List.of(child);
            }
            if (!(child instanceof DBSObjectContainer)) break;
            parent = oc = (DBSObjectContainer)child;
            ++i;
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<? extends DBSProcedure> findProcedures(@NotNull DBRProgressMonitor monitor, @NotNull DBSProcedureContainer procsContainer, @NotNull String procedureName) throws DBException {
        try {
            DBSProcedure child = procsContainer.getProcedure(monitor, procedureName);
            if (child != null) {
                return List.of(child);
            }
            Collection procs = procsContainer.getProcedures(monitor);
            if (procs != null) {
                List<DBSProcedure> matchedProcs = procs.stream().filter(p -> p.getName().equals(procedureName)).toList();
                if (!matchedProcs.isEmpty()) {
                    return matchedProcs;
                }
                return Collections.emptyList();
            }
            return Collections.emptyList();
        }
        catch (DBException e) {
            log.debug((Object)"Error loading procedures for semantic analysis", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

