/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.actions;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.hints.DBDValueHint;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.actions.AbstractResultSetViewerAction;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class HintConfigurationAction
extends AbstractResultSetViewerAction {
    private static final Log log = Log.getLog(HintConfigurationAction.class);
    private final DBDAttributeBinding attr;
    private final DBDValueHint hint;
    private final UIPropertyConfiguratorDescriptor configDescriptor;

    public HintConfigurationAction(@NotNull ResultSetViewer resultSetViewer, @NotNull DBDAttributeBinding attr, @NotNull DBDValueHint hint, @NotNull UIPropertyConfiguratorDescriptor configDescriptor) {
        super(resultSetViewer, hint.getHintDescription() + " ...");
        this.attr = attr;
        this.hint = hint;
        this.configDescriptor = configDescriptor;
        this.setToolTipText(hint.getHintDescription());
    }

    public void run() {
        ConfigDialog dialog = new ConfigDialog(this.getResultSetViewer().getSite().getShell());
        if (dialog.open() == 0) {
            this.getResultSetViewer().refreshData(null);
        }
    }

    private class ConfigDialog
    extends BaseDialog {
        private IObjectPropertyConfigurator<DBDValueHint, DBDAttributeBinding> configurator;

        public ConfigDialog(Shell parentShell) {
            super(parentShell, HintConfigurationAction.this.hint.getHintDescription(), null);
        }

        protected Composite createDialogArea(Composite parent) {
            Composite composite = super.createDialogArea(parent);
            try {
                this.configurator = HintConfigurationAction.this.configDescriptor.createConfigurator();
                this.configurator.createControl(composite, (Object)HintConfigurationAction.this.hint, () -> {});
                this.configurator.loadSettings((Object)HintConfigurationAction.this.attr);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return composite;
        }

        protected void okPressed() {
            this.configurator.saveSettings((Object)HintConfigurationAction.this.attr);
            super.okPressed();
        }
    }
}

