/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.configuration;

import java.nio.file.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.tools.configuration.ConfigurationImportData;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;

public class ConfigurationImportWizardPage
extends WizardPage {
    private TextWithOpen file;

    public ConfigurationImportWizardPage() {
        super(CoreMessages.dialog_workspace_import_wizard_name);
        this.setTitle(CoreMessages.dialog_workspace_import_wizard_title);
        this.setMessage(CoreMessages.dialog_workspace_import_wizard_start_message_configure_settings);
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Group importSettingsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_workspace_import_wizard_group, (int)2, (int)1808, (int)0);
        UIUtils.createControlLabel((Composite)importSettingsGroup, (String)CoreMessages.dialog_workspace_import_wizard_file_select_name);
        this.file = new TextWithOpenFile((Composite)importSettingsGroup, CoreMessages.dialog_workspace_import_wizard_file_select_title, new String[]{"*.zip"});
        this.file.setLayoutData((Object)new GridData(768));
        this.file.getTextControl().addModifyListener(e -> this.getContainer().updateButtons());
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        try {
            return !this.file.getText().isEmpty() && Path.of(this.file.getText(), new String[0]).toFile().exists() && this.file.getText().endsWith(".zip");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ConfigurationImportData getConfigurationImportData() {
        return new ConfigurationImportData(this.file.getTextControl().getText());
    }
}

