import * as lst from "vscode-languageserver-types";
import { getEdgeStr } from "./common.js";
export function create(startOffset, endOffset, changeTo, changeFrom) {
    const from = getEdgeStr(changeFrom);
    const to = getEdgeStr(changeTo);
    return {
        title: `Change "${from}" to "${to}".`,
        command: "DOT.changeEdgeOp",
        arguments: [startOffset, endOffset, to],
    };
}
export function execute(doc, _sourceFile, cmd) {
    if (!isChangeEdgeOpCommand(cmd))
        return undefined;
    const [startOffset, endOffset, changeTo] = cmd.arguments;
    const startPos = doc.positionAt(startOffset);
    const endPos = doc.positionAt(endOffset);
    return {
        label: `Change of invalid edge to "${changeTo}"'"`,
        edit: {
            changes: {
                [doc.uri]: [lst.TextEdit.replace(lst.Range.create(startPos, endPos), changeTo)],
            },
        },
    };
}
function isChangeEdgeOpCommand(cmd) {
    return cmd.command === "DOT.changeEdgeOp" && !!cmd.arguments && cmd.arguments.length === 3;
}
//# sourceMappingURL=ChangeEdgeOpCommand.js.map