/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.InstanceKind$;
import firrtl.Kind;
import firrtl.MemKind$;
import firrtl.MemoryArrayInit;
import firrtl.MemoryInitValue;
import firrtl.MemoryScalarInit;
import firrtl.PortKind$;
import firrtl.RegKind$;
import firrtl.Utils$;
import firrtl.WireKind$;
import firrtl.backends.experimental.smt.ArrayConstant;
import firrtl.backends.experimental.smt.ArrayExpr;
import firrtl.backends.experimental.smt.ArrayIte;
import firrtl.backends.experimental.smt.ArrayRead;
import firrtl.backends.experimental.smt.ArrayStore;
import firrtl.backends.experimental.smt.ArraySymbol;
import firrtl.backends.experimental.smt.AsyncResetException;
import firrtl.backends.experimental.smt.BVAnd$;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVFunctionCall;
import firrtl.backends.experimental.smt.BVImplies$;
import firrtl.backends.experimental.smt.BVLiteral;
import firrtl.backends.experimental.smt.BVNot$;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.False$;
import firrtl.backends.experimental.smt.FirrtlExpressionSemantics$;
import firrtl.backends.experimental.smt.IsBad$;
import firrtl.backends.experimental.smt.IsConstraint$;
import firrtl.backends.experimental.smt.IsNode$;
import firrtl.backends.experimental.smt.IsOutput$;
import firrtl.backends.experimental.smt.MultiClockException;
import firrtl.backends.experimental.smt.SMTExpr;
import firrtl.backends.experimental.smt.SMTSymbol;
import firrtl.backends.experimental.smt.Signal;
import firrtl.backends.experimental.smt.Signal$;
import firrtl.backends.experimental.smt.State;
import firrtl.backends.experimental.smt.TransitionSystem;
import firrtl.backends.experimental.smt.UninterpretedModuleAnnotation;
import firrtl.backends.experimental.smt.UnsupportedFeatureException;
import firrtl.backends.experimental.smt.random.DefRandom;
import firrtl.bitWidth$;
import firrtl.ir.AsyncResetType$;
import firrtl.ir.Attach;
import firrtl.ir.BundleType;
import firrtl.ir.ClockType$;
import firrtl.ir.Conditionally;
import firrtl.ir.Connect;
import firrtl.ir.DefInstance;
import firrtl.ir.DefMemory;
import firrtl.ir.DefNode;
import firrtl.ir.DefRegister;
import firrtl.ir.DefWire;
import firrtl.ir.Default$;
import firrtl.ir.Direction;
import firrtl.ir.Expression;
import firrtl.ir.Field;
import firrtl.ir.Formal$;
import firrtl.ir.GroundType;
import firrtl.ir.Info;
import firrtl.ir.Input$;
import firrtl.ir.IsInvalid;
import firrtl.ir.Module;
import firrtl.ir.Orientation;
import firrtl.ir.Output$;
import firrtl.ir.PartialConnect;
import firrtl.ir.Port;
import firrtl.ir.Print;
import firrtl.ir.Statement;
import firrtl.ir.Stop;
import firrtl.ir.Type;
import firrtl.ir.Verification;
import firrtl.passes.MemPortUtils$;
import java.io.Serializable;
import logger.LazyLogging;
import logger.Logger;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordering$Int$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001B\u0010!\t%B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0004g\u0001\t\u0007I\u0011B4\t\rM\u0004\u0001\u0015!\u0003i\u0011\u001d!\bA1A\u0005\nUDaa\u001e\u0001!\u0002\u00131\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007}\u0002\u0001\u000b\u0011\u0002>\t\u0011}\u0004!\u0019!C\u0005\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'A\u0001\"a\t\u0001A\u0003%\u0011Q\u0003\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\tI\u0004\u0001C\u0005\u0003wAq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u0011Q\u0010\u0001\u0005\n\u0005}\u0004bBAE\u0001\u0011%\u00111\u0012\u0005\b\u0003O\u0003A\u0011BAU\u0011\u001d\ti\u000b\u0001C\u0005\u0003_C\u0011\"a4\u0001#\u0003%I!!5\t\u000f\u00055\u0006\u0001\"\u0003\u0002h\"9\u00111\u001e\u0001\u0005\n\u00055\bbBAz\u0001\u0011%\u0011Q\u001f\u0005\b\u0003s\u0004A\u0011BA~\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003\u0011\u0001$T8ek2,Gk\u001c+sC:\u001c\u0018\u000e^5p]NK8\u000f^3n\u0015\t\t#%A\u0002t[RT!a\t\u0013\u0002\u0019\u0015D\b/\u001a:j[\u0016tG/\u00197\u000b\u0005\u00152\u0013\u0001\u00032bG.,g\u000eZ:\u000b\u0003\u001d\naAZ5seRd7\u0001A\n\u0004\u0001)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u00022i5\t!GC\u00014\u0003\u0019awnZ4fe&\u0011QG\r\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-\u0001\u0006qe\u0016\u001cX\r\u001e*fON\u00042\u0001O C\u001d\tIT\b\u0005\u0002;Y5\t1H\u0003\u0002=Q\u00051AH]8pizJ!A\u0010\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015IA\u0002TKRT!A\u0010\u0017\u0011\u0005a\u001a\u0015B\u0001#B\u0005\u0019\u0019FO]5oO\u00069Q.Z7J]&$\b\u0003\u0002\u001dH\u0005&K!\u0001S!\u0003\u00075\u000b\u0007\u000f\u0005\u0002K\u00176\ta%\u0003\u0002MM\tyQ*Z7pefLe.\u001b;WC2,X-A\u0007v]&tG/\u001a:qe\u0016$X\r\u001a\t\u0005q\u001d\u0013u\n\u0005\u0002Q#6\t\u0001%\u0003\u0002SA\tiRK\\5oi\u0016\u0014\bO]3uK\u0012lu\u000eZ;mK\u0006sgn\u001c;bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0005+Z;\u0006\f\u0005\u0002Q\u0001!)a\u0007\u0002a\u0001o!)Q\t\u0002a\u0001\r\")Q\n\u0002a\u0001\u001d\u0006\u0019!/\u001e8\u0015\u0005ms\u0006C\u0001)]\u0013\ti\u0006E\u0001\tUe\u0006t7/\u001b;j_:\u001c\u0016p\u001d;f[\")q,\u0002a\u0001A\u0006\tQ\u000e\u0005\u0002bI6\t!M\u0003\u0002dM\u0005\u0011\u0011N]\u0005\u0003K\n\u0014a!T8ek2,\u0017AB5oaV$8/F\u0001i!\rIg\u000e]\u0007\u0002U*\u00111\u000e\\\u0001\b[V$\u0018M\u00197f\u0015\tiG&\u0001\u0006d_2dWm\u0019;j_:L!a\u001c6\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003!FL!A\u001d\u0011\u0003\u0011\t36+_7c_2\fq!\u001b8qkR\u001c\b%\u0001\u0004dY>\u001c7n]\u000b\u0002mB\u0019\u0011N\u001c\"\u0002\u000f\rdwnY6tA\u000591/[4oC2\u001cX#\u0001>\u0011\u0007%t7\u0010\u0005\u0002Qy&\u0011Q\u0010\t\u0002\u0007'&<g.\u00197\u0002\u0011MLwM\\1mg\u0002\naa\u001d;bi\u0016\u001cXCAA\u0002!\u0019I\u0017Q\u0001\"\u0002\n%\u0019\u0011q\u00016\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\r\u0001\u00161B\u0005\u0004\u0003\u001b\u0001#!B*uCR,\u0017aB:uCR,7\u000fI\u0001\u0006S:4wn]\u000b\u0003\u0003+\u0001B!\u001b8\u0002\u0018A11&!\u0007C\u0003;I1!a\u0007-\u0005\u0019!V\u000f\u001d7feA\u0019\u0011-a\b\n\u0007\u0005\u0005\"M\u0001\u0003J]\u001a|\u0017AB5oM>\u001c\b%\u0001\u0004p]B{'\u000f\u001e\u000b\u0005\u0003S\ty\u0003E\u0002,\u0003WI1!!\f-\u0005\u0011)f.\u001b;\t\u000f\u0005E\u0002\u00031\u0001\u00024\u0005\t\u0001\u000fE\u0002b\u0003kI1!a\u000ec\u0005\u0011\u0001vN\u001d;\u0002\u0017=t7\u000b^1uK6,g\u000e\u001e\u000b\u0005\u0003S\ti\u0004C\u0004\u0002@E\u0001\r!!\u0011\u0002\u0003M\u00042!YA\"\u0013\r\t)E\u0019\u0002\n'R\fG/Z7f]R\f!b\u001c8SK\u001eL7\u000f^3s)\u0011\tI!a\u0013\t\u000f\u00055#\u00031\u0001\u0002P\u0005\t!\u000fE\u0002b\u0003#J1!a\u0015c\u0005-!UM\u001a*fO&\u001cH/\u001a:\u0002\u0015=t\u0017J\\:uC:\u001cW\r\u0006\u0006\u0002*\u0005e\u0013QLA1\u0003KBq!a\u0017\u0014\u0001\u0004\ti\"\u0001\u0003j]\u001a|\u0007BBA0'\u0001\u0007!)\u0001\u0003oC6,\u0007BBA2'\u0001\u0007!)\u0001\u0004n_\u0012,H.\u001a\u0005\b\u0003O\u001a\u0002\u0019AA5\u0003\r!\b/\u001a\t\u0004C\u0006-\u0014bAA7E\n!A+\u001f9f\u0003]yg.\u00168j]R,'\u000f\u001d:fi\u0016$\u0017J\\:uC:\u001cW\r\u0006\u0006\u0002*\u0005M\u0014QOA=\u0003wBq!a\u0017\u0015\u0001\u0004\ti\u0002\u0003\u0004\u0002xQ\u0001\rAQ\u0001\rS:\u001cH/\u00198dK:\u000bW.\u001a\u0005\u0007\u0003G\"\u0002\u0019\u0001\"\t\u000f\u0005\u001dD\u00031\u0001\u0002j\u0005AqN\\'f[>\u0014\u0018\u0010\u0006\u0003\u0002\n\u0005\u0005\u0005BB0\u0016\u0001\u0004\t\u0019\tE\u0002b\u0003\u000bK1!a\"c\u0005%!UMZ'f[>\u0014\u00180\u0001\u0006hKRlU-\\%oSR$\"\"!$\u0002\u0014\u0006U\u0015qTAR!\r\u0001\u0016qR\u0005\u0004\u0003#\u0003#!C!se\u0006LX\t\u001f9s\u0011\u0019yf\u00031\u0001\u0002\u0004\"9\u0011q\u0013\fA\u0002\u0005e\u0015AC5oI\u0016Dx+\u001b3uQB\u00191&a'\n\u0007\u0005uEFA\u0002J]RDq!!)\u0017\u0001\u0004\tI*A\u0005eCR\fw+\u001b3uQ\"1\u0011Q\u0015\fA\u0002%\u000b\u0011\"\u001b8jiZ\u000bG.^3\u0002\u0011\rDWmY6NK6$B!!\u000b\u0002,\"1ql\u0006a\u0001\u0003\u0007\u000bAb\u001c8FqB\u0014Xm]:j_:$\u0002\"!-\u00028\u0006\u0005\u0017Q\u0019\t\u0004!\u0006M\u0016bAA[A\t1!IV#yaJDq!!/\u0019\u0001\u0004\tY,A\u0001f!\r\t\u0017QX\u0005\u0004\u0003\u007f\u0013'AC#yaJ,7o]5p]\"9\u00111\u0019\rA\u0002\u0005e\u0015!B<jIRD\u0007\"CAd1A\u0005\t\u0019AAe\u0003-\tG\u000e\\8x\u001d\u0006\u0014(o\\<\u0011\u0007-\nY-C\u0002\u0002N2\u0012qAQ8pY\u0016\fg.\u0001\fp]\u0016C\bO]3tg&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019N\u000b\u0003\u0002J\u0006U7FAAl!\u0011\tI.a9\u000e\u0005\u0005m'\u0002BAo\u0003?\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005H&\u0001\u0006b]:|G/\u0019;j_:LA!!:\u0002\\\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0015\t\u0005E\u0016\u0011\u001e\u0005\b\u0003sS\u0002\u0019AA^\u0003\u0015)'O]8s)\u0011\tI#a<\t\r\u0005E8\u00041\u0001C\u0003\ri7oZ\u0001\rSN<%o\\;oIRK\b/\u001a\u000b\u0005\u0003\u0013\f9\u0010C\u0004\u0002hq\u0001\r!!\u001b\u0002\u000f%\u001c8\t\\8dWR!\u0011\u0011ZA\u007f\u0011\u001d\t9'\ba\u0001\u0003S\nA\"[:Bgft7MU3tKR$B!!3\u0003\u0004!9\u0011q\r\u0010A\u0002\u0005%\u0004")
public class ModuleToTransitionSystem
implements LazyLogging {
    private final Set<String> presetRegs;
    private final Map<String, MemoryInitValue> memInit;
    private final Map<String, UninterpretedModuleAnnotation> uninterpreted;
    private final ArrayBuffer<BVSymbol> inputs;
    private final ArrayBuffer<String> clocks;
    private final ArrayBuffer<Signal> signals;
    private final LinkedHashMap<String, State> states;
    private final ArrayBuffer<Tuple2<String, Info>> infos;
    private Logger logger;

    @Override
    public Logger getLogger() {
        return LazyLogging.getLogger$(this);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public TransitionSystem run(Module m) {
        m.foreachPort((Function1<Port, BoxedUnit>)(Function1<Port, Object> & Serializable)p -> {
            this.onPort(p);
            return BoxedUnit.UNIT;
        });
        m.foreachStmt((Function1<Statement, BoxedUnit>)(Function1<Statement, Object> & Serializable)s -> {
            this.onStatement(s);
            return BoxedUnit.UNIT;
        });
        if (this.clocks().size() > 1) {
            throw new MultiClockException(new StringBuilder(37).append("The module ").append(m.name()).append(" has more than one clock: ").append(this.clocks().mkString(", ")).toString());
        }
        HashMap comments = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.infos().foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            ModuleToTransitionSystem.$anonfun$run$3(comments, x0$1);
            return BoxedUnit.UNIT;
        });
        String header = m.info().serialize().trim();
        return new TransitionSystem(m.name(), this.inputs().toList(), this.states().values().toList(), this.signals().toList(), comments.toMap($less$colon$less$.MODULE$.refl()), header);
    }

    private ArrayBuffer<BVSymbol> inputs() {
        return this.inputs;
    }

    private ArrayBuffer<String> clocks() {
        return this.clocks;
    }

    private ArrayBuffer<Signal> signals() {
        return this.signals;
    }

    private LinkedHashMap<String, State> states() {
        return this.states;
    }

    private ArrayBuffer<Tuple2<String, Info>> infos() {
        return this.infos;
    }

    private void onPort(Port p) {
        if (this.isAsyncReset(p.tpe())) {
            throw new AsyncResetException(new StringBuilder(18).append("Found AsyncReset ").append(p.name()).append(".").toString());
        }
        this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(p.name()), p.info()));
        Direction direction = p.direction();
        if (Input$.MODULE$.equals(direction)) {
            BoxedUnit boxedUnit;
            if (this.isClock(p.tpe())) {
                this.clocks().append(p.name());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.inputs().append(new BVSymbol(p.name(), bitWidth$.MODULE$.apply(p.tpe()).toInt()));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (Output$.MODULE$.equals(direction)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(direction);
        }
    }

    private void onStatement(Statement s2) {
        Statement statement = s2;
        if (statement instanceof DefRandom) {
            DefRandom defRandom = (DefRandom)statement;
            Info info = defRandom.info();
            String name = defRandom.name();
            Type tpe = defRandom.tpe();
            Expression en = defRandom.en();
            Predef$.MODULE$.assert(!this.isClock(tpe), (Function0<Object>)(Function0<String> & Serializable)() -> "rand should never be a clock!");
            this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), info));
            this.inputs().append(new BVSymbol(name, bitWidth$.MODULE$.apply(tpe).toInt()));
            this.signals().append(new Signal(new StringBuilder(3).append(name).append(".en").toString(), this.onExpression(en, 1, this.onExpression$default$3()), IsOutput$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefWire) {
            DefWire defWire = (DefWire)statement;
            BoxedUnit boxedUnit = !this.isClock(defWire.tpe()) ? BoxedUnit.UNIT : BoxedUnit.UNIT;
        } else if (statement instanceof DefNode) {
            BoxedUnit boxedUnit;
            DefNode defNode = (DefNode)statement;
            Info info = defNode.info();
            String name = defNode.name();
            Expression expr = defNode.value();
            if (!this.isClock(expr.tpe()) && !this.isAsyncReset(expr.tpe())) {
                this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), info));
                this.signals().append(new Signal(name, this.onExpression(expr), IsNode$.MODULE$));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (statement instanceof DefRegister) {
            DefRegister defRegister = (DefRegister)statement;
            this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(defRegister.name()), defRegister.info()));
            this.states().update(defRegister.name(), this.onRegister(defRegister));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof DefMemory) {
            DefMemory defMemory = (DefMemory)statement;
            this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(defMemory.name()), defMemory.info()));
            this.states().update(defMemory.name(), this.onMemory(defMemory));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (statement instanceof Connect) {
            BoxedUnit boxedUnit;
            Connect connect = (Connect)statement;
            Info info = connect.info();
            Expression loc = connect.loc();
            Expression expr = connect.expr();
            if (!this.isGroundType(loc.tpe())) {
                this.error("All connects should have been lowered to ground type!");
            }
            if (!this.isClock(loc.tpe()) && !this.isAsyncReset(expr.tpe())) {
                String name = loc.serialize();
                BVExpr e = this.onExpression(expr, bitWidth$.MODULE$.apply(loc.tpe()).toInt(), false);
                Kind kind = Utils$.MODULE$.kind(loc);
                if (RegKind$.MODULE$.equals(kind)) {
                    State qual$1 = (State)this.states().apply(name);
                    Some<SMTExpr> x$1 = new Some<SMTExpr>(e);
                    SMTSymbol x$2 = qual$1.copy$default$1();
                    Option<SMTExpr> x$3 = qual$1.copy$default$2();
                    this.states().update(name, qual$1.copy(x$2, x$3, x$1));
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boolean bl = PortKind$.MODULE$.equals(kind) ? true : InstanceKind$.MODULE$.equals(kind);
                    if (bl) {
                        this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), info));
                        this.signals().append(new Signal(name, e, IsOutput$.MODULE$));
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boolean bl2 = MemKind$.MODULE$.equals(kind) ? true : WireKind$.MODULE$.equals(kind);
                        if (bl2) {
                            this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), info));
                            this.signals().append(new Signal(name, e, IsNode$.MODULE$));
                            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(kind);
                        }
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else {
            if (statement instanceof IsInvalid) {
                IsInvalid isInvalid = (IsInvalid)statement;
                throw new UnsupportedFeatureException(new StringBuilder(40).append("IsInvalid statements are not supported: ").append(isInvalid.serialize()).toString());
            }
            if (statement instanceof DefInstance) {
                DefInstance defInstance = (DefInstance)statement;
                Info info = defInstance.info();
                String name = defInstance.name();
                String module = defInstance.module();
                Type tpe = defInstance.tpe();
                this.onInstance(info, name, module, tpe);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (statement instanceof Verification) {
                BoxedUnit boxedUnit;
                Verification verification = (Verification)statement;
                Enumeration.Value value = verification.op();
                Enumeration.Value value2 = Formal$.MODULE$.Cover();
                if (!(value != null ? !((Object)value).equals(value2) : value2 != null)) {
                    this.logger().info((Function0<String> & Serializable)() -> new StringBuilder(36).append("[info] Cover statement was ignored: ").append(verification.serialize()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String name = verification.name();
                    BVExpr predicate = this.onExpression(verification.pred());
                    BVExpr enabled = this.onExpression(verification.en());
                    BVExpr e = BVImplies$.MODULE$.apply(enabled, predicate);
                    this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), verification.info()));
                    Enumeration.Value value3 = verification.op();
                    Enumeration.Value value4 = Formal$.MODULE$.Assert();
                    Signal signal = !(value3 != null ? !((Object)value3).equals(value4) : value4 != null) ? new Signal(name, BVNot$.MODULE$.apply(e), IsBad$.MODULE$) : new Signal(name, e, IsConstraint$.MODULE$);
                    this.signals().append(signal);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit7 = boxedUnit;
            } else if (statement instanceof Conditionally) {
                Conditionally conditionally = (Conditionally)statement;
                this.error(new StringBuilder(59).append("When conditions are not supported. Please run ExpandWhens: ").append(conditionally.serialize()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (statement instanceof PartialConnect) {
                PartialConnect partialConnect = (PartialConnect)statement;
                this.error(new StringBuilder(62).append("PartialConnects are not supported. Please run ExpandConnects: ").append(partialConnect.serialize()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (statement instanceof Attach) {
                Attach attach = (Attach)statement;
                this.error(new StringBuilder(51).append("Analog wires are not supported in the SMT backend: ").append(attach.serialize()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (statement instanceof Stop) {
                BoxedUnit boxedUnit;
                Stop stop = (Stop)statement;
                if (stop.ret() == 0) {
                    this.logger().info((Function0<String> & Serializable)() -> new StringBuilder(86).append("[info] Stop statements with a return code of 0 are currently not supported. Ignoring: ").append(stop.serialize()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    String name = stop.name();
                    this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), stop.info()));
                    this.signals().append(new Signal(name, this.onExpression(stop.en()), IsBad$.MODULE$));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit8 = boxedUnit;
            } else if (statement instanceof Print) {
                Print print = (Print)statement;
                this.logger().info((Function0<String> & Serializable)() -> new StringBuilder(16).append("Info: ignoring: ").append(print.serialize()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                statement.foreachStmt((Function1<Statement, BoxedUnit>)(Function1<Statement, Object> & Serializable)s -> {
                    this.onStatement(s);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private State onRegister(DefRegister r) {
        BVExpr resetExpr;
        int width = bitWidth$.MODULE$.apply(r.tpe()).toInt();
        BVExpr bVExpr = resetExpr = this.onExpression(r.reset(), 1, this.onExpression$default$3());
        BVLiteral bVLiteral = False$.MODULE$.apply();
        Predef$.MODULE$.assert(!(bVExpr != null ? !bVExpr.equals(bVLiteral) : bVLiteral != null), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(43).append("Expected reset expression of ").append(r.name()).append(" to be 0, not ").append(resetExpr).toString());
        BVExpr initExpr = this.onExpression(r.init(), width, this.onExpression$default$3());
        BVSymbol sym = new BVSymbol(r.name(), width);
        BVExpr bVExpr2 = initExpr;
        BVSymbol bVSymbol = sym;
        boolean hasReset = bVExpr2 == null ? bVSymbol != null : !bVExpr2.equals(bVSymbol);
        boolean isPreset = this.presetRegs.contains(r.name());
        Predef$.MODULE$.assert(!isPreset || hasReset, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(59).append("Expected preset register ").append(r.name()).append(" to have a reset value, not just ").append(initExpr).append("!").toString());
        State state = new State(sym, isPreset ? new Some<BVExpr>(initExpr) : None$.MODULE$, None$.MODULE$);
        return state;
    }

    private void onInstance(Info info, String name, String module, Type tpe) {
        if (!(tpe instanceof BundleType)) {
            this.error(new StringBuilder(35).append("Instance ").append(name).append(" of ").append(module).append(" has an invalid type: ").append(tpe.serialize()).toString());
        }
        if (this.uninterpreted.contains(module)) {
            this.onUninterpretedInstance(info, name, module, tpe);
        } else {
            this.logger().warn((Function0<String> & Serializable)() -> new StringBuilder(84).append(new StringBuilder(42).append("WARN: treating instance ").append(name).append(" of ").append(module).append(" as blackbox. ").toString()).append("Please flatten your hierarchy if you want to include submodules in the formal model.").toString());
            Seq<Field> ports = ((BundleType)tpe).fields();
            ((IterableOnceOps)ports.filterNot((Function1<Field, Object> & Serializable)p -> BoxesRunTime.boxToBoolean(this.isAsyncReset(p.tpe())))).foreach((Function1<Field, Object> & Serializable)p -> {
                if (!(p.tpe() instanceof GroundType)) {
                    this.error(new StringBuilder(40).append("Instance ").append(name).append(" of ").append(module).append(" has an invalid port type: ").append(p).toString());
                }
                Orientation orientation = p.flip();
                Default$ default$ = Default$.MODULE$;
                boolean isOutput = !(orientation != null ? !orientation.equals(default$) : default$ != null);
                String pName = new StringBuilder(1).append(name).append(".").append(p.name()).toString();
                this.infos().append(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pName), info));
                return isOutput ? (this.isClock(p.tpe()) ? this.clocks().append(pName) : this.inputs().append(new BVSymbol(pName, bitWidth$.MODULE$.apply(p.tpe()).toInt()))) : BoxedUnit.UNIT;
            });
        }
    }

    private void onUninterpretedInstance(Info info, String instanceName, String module, Type tpe) {
        UninterpretedModuleAnnotation anno = (UninterpretedModuleAnnotation)this.uninterpreted.apply(module);
        Seq<Field> ports = ((BundleType)tpe).fields();
        Seq outputs = (Seq)((IterableOps)ports.filter((Function1<Field, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(ModuleToTransitionSystem.$anonfun$onUninterpretedInstance$1(x$3)))).map((Function1<Field, BVSymbol> & Serializable)p -> new BVSymbol(p.name(), bitWidth$.MODULE$.apply(p.tpe()).toInt()));
        Seq inputs = (Seq)((IterableOps)ports.filterNot((Function1<Field, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(ModuleToTransitionSystem.$anonfun$onUninterpretedInstance$3(x$4)))).map((Function1<Field, BVSymbol> & Serializable)p -> new BVSymbol(p.name(), bitWidth$.MODULE$.apply(p.tpe()).toInt()));
        Predef$.MODULE$.assert(anno.stateBits() == 0, (Function0<Object>)(Function0<String> & Serializable)() -> "TODO: implement support for uninterpreted stateful modules!");
        List args = ((IterableOnceOps)inputs.map((Function1<BVSymbol, BVSymbol> & Serializable)i -> new BVSymbol(new StringBuilder(1).append(instanceName).append(".").append(i.name()).toString(), i.width()))).toList();
        outputs.foreach((Function1<BVSymbol, ArrayBuffer> & Serializable)out -> {
            String functionName = new StringBuilder(1).append(anno.prefix()).append(".").append(out.name()).toString();
            BVFunctionCall call = new BVFunctionCall(functionName, args, out.width());
            String wireName = new StringBuilder(1).append(instanceName).append(".").append(out.name()).toString();
            return (ArrayBuffer)this.signals().append(new Signal(wireName, call, Signal$.MODULE$.apply$default$3()));
        });
    }

    private State onMemory(DefMemory m) {
        this.checkMem(m);
        int dataWidth = bitWidth$.MODULE$.apply(m.dataType()).toInt();
        int indexWidth = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(Utils$.MODULE$.getUIntWidth(m.depth().$minus(BigInt$.MODULE$.int2bigInt(1)))), 1);
        ArraySymbol memSymbol = new ArraySymbol(m.name(), indexWidth, dataWidth);
        Option<SMTExpr> init = this.memInit.get(m.name()).map((Function1<MemoryInitValue, ArrayExpr> & Serializable)x$5 -> this.getMemInit(m, indexWidth, dataWidth, (MemoryInitValue)x$5));
        init.foreach((Function1<ArrayExpr, Object> & Serializable)e -> {
            Predef$.MODULE$.assert(e.dataWidth() == memSymbol.dataWidth() && e.indexWidth() == memSymbol.indexWidth());
            return BoxedUnit.UNIT;
        });
        ArraySymbol next = m.writers().isEmpty() ? memSymbol : (ArrayExpr)m.writers().foldLeft(memSymbol, (Function2<ArrayExpr, String, ArrayExpr> & Serializable)(x0$1, x1$1) -> {
            Tuple2<ArrayExpr, String> tuple2 = new Tuple2<ArrayExpr, String>((ArrayExpr)x0$1, (String)x1$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ArrayExpr prev = tuple2._1();
            String write2 = tuple2._2();
            BVSymbol addr = new BVSymbol(MemPortUtils$.MODULE$.memPortField(m, write2, "addr").serialize(), indexWidth);
            BVSymbol data2 = new BVSymbol(MemPortUtils$.MODULE$.memPortField(m, write2, "data").serialize(), dataWidth);
            ArrayStore update2 = new ArrayStore(prev, addr, data2);
            BVSymbol en = new BVSymbol(MemPortUtils$.MODULE$.memPortField(m, write2, "en").serialize(), 1);
            BVSymbol mask = new BVSymbol(MemPortUtils$.MODULE$.memPortField(m, write2, "mask").serialize(), 1);
            ArrayIte arrayIte = new ArrayIte(BVAnd$.MODULE$.apply(en, mask), update2, prev);
            return arrayIte;
        });
        State state = new State(memSymbol, init, new Some<SMTExpr>(next));
        Seq readSignals = (Seq)m.readers().map((Function1<String, Signal> & Serializable)read2 -> {
            BVSymbol addr = new BVSymbol(MemPortUtils$.MODULE$.memPortField(m, (String)read2, "addr").serialize(), indexWidth);
            return new Signal(MemPortUtils$.MODULE$.memPortField(m, (String)read2, "data").serialize(), new ArrayRead(memSymbol, addr), IsNode$.MODULE$);
        });
        this.signals().$plus$plus$eq(readSignals);
        return state;
    }

    private ArrayExpr getMemInit(DefMemory m, int indexWidth, int dataWidth, MemoryInitValue initValue) {
        ArrayExpr arrayExpr;
        MemoryInitValue memoryInitValue = initValue;
        if (memoryInitValue instanceof MemoryScalarInit) {
            MemoryScalarInit memoryScalarInit = (MemoryScalarInit)memoryInitValue;
            BigInt value = memoryScalarInit.value();
            arrayExpr = new ArrayConstant(new BVLiteral(value, dataWidth), indexWidth);
        } else if (memoryInitValue instanceof MemoryArrayInit) {
            MemoryArrayInit memoryArrayInit = (MemoryArrayInit)memoryInitValue;
            Seq<BigInt> values = memoryArrayInit.values();
            Predef$.MODULE$.assert(BoxesRunTime.equals(BoxesRunTime.boxToInteger(values.length()), m.depth()), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(65).append("Memory ").append(m.name()).append(" of depth ").append(m.depth()).append(" cannot be initialized with an array of length ").append(values.length()).append("!").toString());
            LinkedHashMap histogram = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            values.foreach((Function1<BigInt, Object> & Serializable)v -> {
                histogram.update(v, BoxesRunTime.boxToInteger(1 + BoxesRunTime.unboxToInt(histogram.getOrElse(v, () -> 0))));
                return BoxedUnit.UNIT;
            });
            BigInt baseValue = (BigInt)((Tuple2)histogram.maxBy((Function1<Tuple2, Object> & Serializable)x$6 -> BoxesRunTime.boxToInteger(x$6._2$mcI$sp()), Ordering$Int$.MODULE$))._1();
            ArrayConstant base = new ArrayConstant(new BVLiteral(baseValue, dataWidth), indexWidth);
            arrayExpr = ((IterableOnceOps)((IterableOps)values.zipWithIndex()).filterNot((Function1<Tuple2, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(ModuleToTransitionSystem.$anonfun$getMemInit$5(baseValue, x$7)))).foldLeft(base, (Function2<ArrayExpr, Tuple2, ArrayExpr> & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                ArrayExpr array;
                block3: {
                    Tuple2<ArrayExpr, Tuple2> tuple22;
                    block2: {
                        tuple22 = new Tuple2<ArrayExpr, Tuple2>((ArrayExpr)x0$1, (Tuple2)x1$1);
                        if (tuple22 == null) break block2;
                        array = tuple22._1();
                        tuple2 = tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError(tuple22);
                }
                BigInt value = (BigInt)tuple2._1();
                int index = tuple2._2$mcI$sp();
                ArrayStore arrayStore = new ArrayStore(array, new BVLiteral(BigInt$.MODULE$.int2bigInt(index), indexWidth), new BVLiteral(value, dataWidth));
                return arrayStore;
            });
        } else {
            throw new RuntimeException(new StringBuilder(32).append("Unsupported memory init option: ").append(memoryInitValue).toString());
        }
        return arrayExpr;
    }

    private void checkMem(DefMemory m) {
        Predef$.MODULE$.assert(m.readLatency() == 0, (Function0<Object>)(Function0<String> & Serializable)() -> "Expected read latency to be 0. Did you run VerilogMemDelays?");
        Predef$.MODULE$.assert(m.writeLatency() == 1, (Function0<Object>)(Function0<String> & Serializable)() -> "Expected read latency to be 1. Did you run VerilogMemDelays?");
        Predef$.MODULE$.assert(m.dataType() instanceof GroundType, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(47).append("Memory ").append(m).append(" is of type ").append(m.dataType()).append(" which is not a ground type!").toString());
        Predef$.MODULE$.assert(m.readwriters().isEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> "Combined read/write ports are not supported! Please split them up.");
    }

    private BVExpr onExpression(Expression e, int width, boolean allowNarrow) {
        return FirrtlExpressionSemantics$.MODULE$.toSMT(e, width, allowNarrow);
    }

    private BVExpr onExpression(Expression e) {
        return FirrtlExpressionSemantics$.MODULE$.toSMT(e);
    }

    private boolean onExpression$default$3() {
        return false;
    }

    private void error(String msg) {
        throw new RuntimeException(msg);
    }

    private boolean isGroundType(Type tpe) {
        return tpe instanceof GroundType;
    }

    private boolean isClock(Type tpe) {
        Type type = tpe;
        ClockType$ clockType$ = ClockType$.MODULE$;
        return !(type != null ? !type.equals(clockType$) : clockType$ != null);
    }

    private boolean isAsyncReset(Type tpe) {
        Type type = tpe;
        AsyncResetType$ asyncResetType$ = AsyncResetType$.MODULE$;
        return !(type != null ? !type.equals(asyncResetType$) : asyncResetType$ != null);
    }

    public static final /* synthetic */ void $anonfun$run$3(HashMap comments$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Info info = (Info)tuple2._2();
            String infoStr = info.serialize().trim();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(infoStr))) {
                String prefix = (String)comments$1.get(name).map((Function1<String, String> & Serializable)x$2 -> new StringBuilder(2).append((String)x$2).append(", ").toString()).getOrElse((Function0<String> & Serializable)() -> "");
                comments$1.update(name, new StringBuilder(0).append(prefix).append(infoStr).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$onUninterpretedInstance$1(Field x$3) {
        Orientation orientation = x$3.flip();
        Default$ default$ = Default$.MODULE$;
        return !(orientation != null ? !orientation.equals(default$) : default$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$onUninterpretedInstance$3(Field x$4) {
        Orientation orientation = x$4.flip();
        Default$ default$ = Default$.MODULE$;
        return !(orientation != null ? !orientation.equals(default$) : default$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getMemInit$5(BigInt baseValue$1, Tuple2 x$7) {
        return BoxesRunTime.equals(x$7._1(), baseValue$1);
    }

    public ModuleToTransitionSystem(Set<String> presetRegs, Map<String, MemoryInitValue> memInit, Map<String, UninterpretedModuleAnnotation> uninterpreted) {
        this.presetRegs = presetRegs;
        this.memInit = memInit;
        this.uninterpreted = uninterpreted;
        LazyLogging.$init$(this);
        this.inputs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.clocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.signals = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.states = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.infos = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Statics.releaseFence();
    }
}

