# Completions for the Elixir build tool mix

function __fish_mix_needs_command
    set -l cmd (commandline -xpc)
    if test (count $cmd) -eq 1
        return 0
    end
    return 1
end

function __fish_mix_using_command
    set -l cmd (commandline -xpc)
    if test (count $cmd) -gt 1
        if test $argv[1] = $cmd[2]
            return 0
        end
    end
    return 1
end

complete -f -c mix -n __fish_mix_needs_command -a app.start -d "Starts all registered apps"
complete -f -c mix -n __fish_mix_needs_command -a archive -d "Lists all archives"
complete -f -c mix -n __fish_mix_needs_command -a archive.build -d "Archives this project into a .ez file"
complete -c mix -n __fish_mix_needs_command -a archive.install -d "Installs an archive locally"
complete -c mix -n __fish_mix_needs_command -a archive.uninstall -d "Uninstalls archives"
complete -f -c mix -n __fish_mix_needs_command -a clean -d "Deletes generated application files"
complete -f -c mix -n __fish_mix_needs_command -a cmd -d "Executes the given command"
complete -f -c mix -n __fish_mix_needs_command -a compile -d "Compiles source files"
complete -f -c mix -n __fish_mix_needs_command -a compile.phoenix -d "Compiles Phoenix source files that support code reloading"
complete -f -c mix -n __fish_mix_needs_command -a deps -d "Lists dependencies and their status"
complete -f -c mix -n __fish_mix_needs_command -a deps.clean -d "Deletes the given dependencies' files"
complete -f -c mix -n __fish_mix_needs_command -a deps.compile -d "Compiles dependencies"
complete -f -c mix -n __fish_mix_needs_command -a deps.get -d "Gets all out of date dependencies"
complete -f -c mix -n __fish_mix_needs_command -a deps.unlock -d "Unlocks the given dependencies"
complete -f -c mix -n __fish_mix_needs_command -a deps.update -d "Updates the given dependencies"
complete -f -c mix -n __fish_mix_needs_command -a do -d "Executes the tasks separated by comma"
complete -f -c mix -n __fish_mix_needs_command -a escript.build -d "Builds an escript for the project"
complete -f -c mix -n __fish_mix_needs_command -a help -d "Prints help information for tasks"
complete -c mix -n __fish_mix_needs_command -a loadconfig -d "Loads and persists the given configuration"
complete -f -c mix -n __fish_mix_needs_command -a local -d "Lists local tasks"
complete -f -c mix -n __fish_mix_needs_command -a local.hex -d "Installs Hex locally"
complete -f -c mix -n __fish_mix_needs_command -a local.public_keys -d "Manages public keys"
complete -f -c mix -n __fish_mix_needs_command -a local.rebar -d "Installs rebar locally"
complete -f -c mix -n __fish_mix_needs_command -a local.phx -d "Updates the Phoenix project generator locally"
complete -c mix -n __fish_mix_needs_command -a new -d "Creates a new Elixir project"
complete -c mix -n __fish_mix_needs_command -a profile.fprof -d "Profiles the given file or expression with fprof"
complete -f -c mix -n __fish_mix_needs_command -a phx -d "Prints Phoenix tasks and their information."
complete -f -c mix -n __fish_mix_needs_command -a phx.digest -d "Digests and compresses static files"
complete -f -c mix -n __fish_mix_needs_command -a phx.digest.clean -d "Removes old versions of static assets."
complete -f -c mix -n __fish_mix_needs_command -a phx.gen -d "Lists all available Phoenix generators"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.auth -d "Generates authentication logic for a resource"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.cert -d "Generates a self-signed certificate for HTTPS testing"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.channel -d "Generates a Phoenix channel"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.context -d "Generates a context with functions around an Ecto schema"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.embedded -d "Generates an embedded Ecto schema file"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.html -d "Generates context and controller for an HTML resource"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.json -d "Generates context and controller for a JSON resource"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.live -d "Generates LiveView, templates, and context for a resource"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.notifier -d "Generates a notifier that delivers emails by default"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.presence -d "Generates a Presence tracker"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.release -d "Generates release files and optional Dockerfile for release-based deployments"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.schema -d "Generates an Ecto schema and migration file"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.secret -d "Generates a secret"
complete -f -c mix -n __fish_mix_needs_command -a phx.gen.socket -d "Generates a Phoenix socket handler"
complete -f -c mix -n __fish_mix_needs_command -a phx.new -d "Creates a new Phoenix application"
complete -f -c mix -n __fish_mix_needs_command -a phx.new.ecto -d "Creates a new Ecto project within an umbrella project"
complete -f -c mix -n __fish_mix_needs_command -a phx.new.web -d "Creates a new Phoenix web project within an umbrella project"
complete -f -c mix -n __fish_mix_needs_command -a phx.routes -d "Prints all routes"
complete -f -c mix -n __fish_mix_needs_command -a phx.server -d "Starts applications and their servers"
complete -f -c mix -n __fish_mix_needs_command -a run -d "Runs the given file or expression"
complete -f -c mix -n __fish_mix_needs_command -a test -d "Runs a project's tests"

# archive.build subcommand
complete -c mix -n '__fish_mix_using_command archive.build' -s i -d "Specify input directory"
complete -f -c mix -n '__fish_mix_using_command archive.build' -s o -d "Specify output file name"
complete -f -c mix -n '__fish_mix_using_command archive.build' -l no-compile -d "Skip compilation"

# clean subcommand
complete -f -c mix -n '__fish_mix_using_command clean' -l all -d "Clean everything, including dependencies"

# escript.build subcommand
complete -f -c mix -n '__fish_mix_using_command escript.build' -l force -d "Forces compilation regardless of modification times"
complete -f -c mix -n '__fish_mix_using_command escript.build' -l no-compile -d "Skips compilation to .beam files"

# new subcommand
complete -f -c mix -n '__fish_mix_using_command new' -l sup -d "Generate an OTP application skeleton with a supervision tree"
complete -f -c mix -n '__fish_mix_using_command new' -l umbrella -d "Can be given to generate an umbrella project"
complete -f -c mix -n '__fish_mix_using_command new' -l app -d "Can be given in order to name the OTP application"
complete -f -c mix -n '__fish_mix_using_command new' -l module -d "Can be given in order to name the modules in the generated code skeleton"

# run subcommand
complete -c mix -n '__fish_mix_using_command run' -l config -s c -d "Loads the given configuration file"
complete -c mix -n '__fish_mix_using_command run' -l eval -s e -d "Evaluates the given code"
complete -c mix -n '__fish_mix_using_command run' -l require -s r -d "Requires pattern before running the command"
complete -c mix -n '__fish_mix_using_command run' -l parallel-require -s pr -d "Requires pattern in parallel"
complete -c mix -n '__fish_mix_using_command run' -l no-compile -d "Does not compile even if files require compilation"
complete -c mix -n '__fish_mix_using_command run' -l no-deps-check -d "Does not check dependencies"
complete -c mix -n '__fish_mix_using_command run' -l no-halt -d "Does not halt the system after running the command"
complete -c mix -n '__fish_mix_using_command run' -l no-start -d "Does not start applications after compilation"

# test subcommand
complete -c mix -n '__fish_mix_using_command test' -l trace -d "Run tests with detailed reporting; automatically sets `--max-cases` to 1"
complete -c mix -n '__fish_mix_using_command test' -l max-cases -d "Set the maximum number of cases running async"
complete -c mix -n '__fish_mix_using_command test' -l cover -d "The directory to include coverage results"
complete -c mix -n '__fish_mix_using_command test' -l force -d "Forces compilation regardless of modification times"
complete -c mix -n '__fish_mix_using_command test' -l no-compile -d "Do not compile, even if files require compilation"
complete -c mix -n '__fish_mix_using_command test' -l no-start -d "Do not start applications after compilation"
complete -c mix -n '__fish_mix_using_command test' -l no-color -d "Disable color in the output"
complete -c mix -n '__fish_mix_using_command test' -l color -d "Enable color in the output"
complete -c mix -n '__fish_mix_using_command test' -l include -d "Include tests that match the filter"
complete -c mix -n '__fish_mix_using_command test' -l exclude -d "Exclude tests that match the filter"
complete -c mix -n '__fish_mix_using_command test' -l only -d "Run only tests that match the filter"
complete -c mix -n '__fish_mix_using_command test' -l seed -d "Seeds the random number generator used to randomize test order"
complete -c mix -n '__fish_mix_using_command test' -l timeout -d "Set the timeout for the tests"

# phx subcommand
complete -f -c mix -n '__fish_mix_using_command phx' -l version -d "Prints the Phoenix version"
complete -c mix -n '__fish_mix_using_command phx.digest' -s o -d "Specify output file name"
complete -f -c mix -n '__fish_mix_using_command phx.digest' -l no-vsn -d "digest the stylesheet asset references without the query string `?vsn=d`"
complete -c mix -n '__fish_mix_using_command phx.digest.clean' -s o -l output -d "The path to your compiled assets directory. Defaults to priv/static"
complete -f -c mix -n '__fish_mix_using_command phx.digest.clean' -l age -d "Maximum age (in seconds) for assets"
complete -f -c mix -n '__fish_mix_using_command phx.digest.clean' -l keep -d "How many previous versions of assets to keep"
complete -f -c mix -n '__fish_mix_using_command phx.digest.clean' -l all -d "Specifies that all compiled assets (including the manifest) will be removed"
complete -f -c mix -n '__fish_mix_using_command phx.gen.auth' -l web -d "Customize the web module namespace"
complete -f -c mix -n '__fish_mix_using_command phx.gen.auth' -l binary-id -d "Uses `binary_id` for schema's primary key and its references"
complete -f -c mix -n '__fish_mix_using_command phx.gen.auth' -l table -d "Specify the the table name for the migration and schema"
complete -f -c mix -n '__fish_mix_using_command phx.gen.cert' -s o -l output -d "The path and base filename for the certificate and key"
complete -f -c mix -n '__fish_mix_using_command phx.gen.cert' -s n -l name -d "The Common Name value in certificate's subject"
complete -f -c mix -n '__fish_mix_using_command phx.gen.context' -l binary-id -d "Uses `binary_id` for schema's primary key and its references"
complete -f -c mix -n '__fish_mix_using_command phx.gen.context' -l table -d "Specify the the table name for the migration and schema"
complete -f -c mix -n '__fish_mix_using_command phx.gen.context' -l merge-with-existing-context -d "Skips prompt and automatically merge the new schema access functions and tests"
complete -f -c mix -n '__fish_mix_using_command phx.gen.context' -l no-merge-with-existing-context -d "Skips prompt and prevents changes to an existing context"
complete -f -c mix -n '__fish_mix_using_command phx.gen.html' -l context-app -d "Specifies the context app"
complete -f -c mix -n '__fish_mix_using_command phx.gen.html' -l web -d "Customize the web module namespace"
complete -f -c mix -n '__fish_mix_using_command phx.gen.html' -l no-context -d "Omits context internal implementation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.html' -l no-schema -d "Omits schema internal implementation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.html' -l binary-id -d "Uses `binary_id` for schema's primary key and its references"
complete -f -c mix -n '__fish_mix_using_command phx.gen.html' -l table -d "Specify the the table name for the migration and schema"
complete -f -c mix -n '__fish_mix_using_command phx.gen.json' -l context-app -d "Specifies the context app"
complete -f -c mix -n '__fish_mix_using_command phx.gen.json' -l web -d "Customize the web module namespace"
complete -f -c mix -n '__fish_mix_using_command phx.gen.json' -l no-context -d "Omits context internal implementation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.json' -l no-schema -d "Omits schema internal implementation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.json' -l binary-id -d "Uses `binary_id` for schema's primary key and its references"
complete -f -c mix -n '__fish_mix_using_command phx.gen.json' -l table -d "Specify the the table name for the migration and schema"
complete -f -c mix -n '__fish_mix_using_command phx.gen.live' -l context-app -d "Specifies the context app"
complete -f -c mix -n '__fish_mix_using_command phx.gen.live' -l web -d "Customize the web module namespace"
complete -f -c mix -n '__fish_mix_using_command phx.gen.live' -l no-context -d "Omits context internal implementation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.live' -l no-schema -d "Omits schema internal implementation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.live' -l binary-id -d "Uses `binary_id` for schema's primary key and its references"
complete -f -c mix -n '__fish_mix_using_command phx.gen.live' -l table -d "Specify the the table name for the migration and schema"
complete -f -c mix -n '__fish_mix_using_command phx.gen.notifier' -l context-app -d "Specifies the context app"
complete -f -c mix -n '__fish_mix_using_command phx.gen.release' -l docker -d "Generates a Docker and .dockerignore file"
complete -f -c mix -n '__fish_mix_using_command phx.gen.release' -l no-ecto -d "Skip migration-related file generation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.release' -l ecto -d "Force migration-related file generation"
complete -f -c mix -n '__fish_mix_using_command phx.gen.schema' -l no-migration -d "Omits migration file"
complete -f -c mix -n '__fish_mix_using_command phx.gen.schema' -l context-app -d "Specifies the context app"
complete -f -c mix -n '__fish_mix_using_command phx.gen.schema' -l table -d "Specify the the table name for the migration and schema"
complete -f -c mix -n '__fish_mix_using_command phx.gen.schema' -l binary-id -d "Uses `binary_id` for schema's primary key and its references"
complete -f -c mix -n '__fish_mix_using_command phx.gen.schema' -l no-binary-id -d "Use normal ids despite the default configuration"
complete -f -c mix -n '__fish_mix_using_command phx.gen.schema' -l prefix -d "Specifies a prefix"
complete -f -c mix -n '__fish_mix_using_command phx.gen.schema' -l migration -d "Force generation of the migration"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l umbrella -d "Generate an umbrella project (one app for your domain, a second app for web interface)"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l app -d "The name of the OTP application"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l module -d "The name of the base module in the generated skeleton"
complete -x -c mix -n '__fish_mix_using_command phx.new' -l database -a "postgres mysql mssql sqlite3" -d "Specify the database adapter for Ecto"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-assets -d "Do not generate the assets folder"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-ecto -d "Do not generate Ecto files"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-html -d "Do not generate HTML views"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-gettext -d "Do not generate gettext files"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-dashboard -d "Do not include Phoenix.LiveDashboard"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-live -d "Comment out LiveView socket setup in assets/js/app.js"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-mailer -d "Do not generate Swoosh mailer files"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-esbuild -d "Do not include esbuild dependencies and assets"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-tailwind -d "Do not include tailwind dependencies and assets"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l binary-id -d "Use binary_id as primary key type in Ecto schemas"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l verbose -d "Use verbose output"
complete -f -c mix -n '__fish_mix_using_command phx.new' -s v -l version -d "Prints the Phoenix installer version"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-context -d "Omits context internal implementation"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l no-install -d "Disable prompt to install dependencies"
complete -f -c mix -n '__fish_mix_using_command phx.new' -l install -d "Force prompt to install dependencies"
complete -f -c mix -n '__fish_mix_using_command phx.new.ecto' -l app -d "The name of the OTP application"
complete -f -c mix -n '__fish_mix_using_command phx.new.ecto' -l module -d "The name of the base module in the generated skeleton"
complete -f -c mix -n '__fish_mix_using_command phx.new.ecto' -l database -d "Specify the database adapter for Ecto"
complete -f -c mix -n '__fish_mix_using_command phx.new.ecto' -l binary-id -d "Use binary_id as primary key type in Ecto schemas"
complete -f -c mix -n '__fish_mix_using_command phx.new.web' -l app -d "The name of the OTP application"
complete -f -c mix -n '__fish_mix_using_command phx.new.web' -l module -d "The name of the base module in the generated skeleton"
complete -f -c mix -n '__fish_mix_using_command phx.routes' -l info -d "Locate the controller function definition called by the given url"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l open -d "Open browser window for each started endpoint"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l config -s c -d "Loads the given configuration file"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l eval -s e -d "Evaluates the given code"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l require -s r -d "Requires pattern before running the command"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l parallel-require -s pr -d "Requires pattern in parallel"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l no-compile -d "Does not compile even if files require compilation"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l no-deps-check -d "Does not check dependencies"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l no-halt -d "Does not halt the system after running the command"
complete -f -c mix -n '__fish_mix_using_command phx.server' -l no-start -d "Does not start applications after compilation"

# help subcommand
complete -f -c mix -n '__fish_mix_using_command help' -a app.start -d "Starts all registered apps"
complete -f -c mix -n '__fish_mix_using_command help' -a archive -d "Lists all archives"
complete -f -c mix -n '__fish_mix_using_command help' -a archive.build -d "Archives this project into a .ez file"
complete -f -c mix -n '__fish_mix_using_command help' -a archive.install -d "Installs an archive locally"
complete -f -c mix -n '__fish_mix_using_command help' -a archive.uninstall -d "Uninstalls archives"
complete -f -c mix -n '__fish_mix_using_command help' -a clean -d "Deletes generated application files"
complete -f -c mix -n '__fish_mix_using_command help' -a cmd -d "Executes the given command"
complete -f -c mix -n '__fish_mix_using_command help' -a compile -d "Compiles source files"
complete -f -c mix -n '__fish_mix_using_command help' -a compile.phoenix -d "Compiles Phoenix source files that support code reloading"
complete -f -c mix -n '__fish_mix_using_command help' -a deps -d "Lists dependencies and their status"
complete -f -c mix -n '__fish_mix_using_command help' -a deps.clean -d "Deletes the given dependencies' files"
complete -f -c mix -n '__fish_mix_using_command help' -a deps.compile -d "Compiles dependencies"
complete -f -c mix -n '__fish_mix_using_command help' -a deps.get -d "Gets all out of date dependencies"
complete -f -c mix -n '__fish_mix_using_command help' -a deps.unlock -d "Unlocks the given dependencies"
complete -f -c mix -n '__fish_mix_using_command help' -a deps.update -d "Updates the given dependencies"
complete -f -c mix -n '__fish_mix_using_command help' -a do -d "Executes the tasks separated by comma"
complete -f -c mix -n '__fish_mix_using_command help' -a escript.build -d "Builds an escript for the project"
complete -f -c mix -n '__fish_mix_using_command help' -a help -d "Prints help information for tasks"
complete -f -c mix -n '__fish_mix_using_command help' -a loadconfig -d "Loads and persists the given configuration"
complete -f -c mix -n '__fish_mix_using_command help' -a local -d "Lists local tasks"
complete -f -c mix -n '__fish_mix_using_command help' -a local.hex -d "Installs Hex locally"
complete -f -c mix -n '__fish_mix_using_command help' -a local.public_keys -d "Manages public keys"
complete -f -c mix -n '__fish_mix_using_command help' -a local.rebar -d "Installs rebar locally"
complete -f -c mix -n '__fish_mix_using_command help' -a new -d "Creates a new Elixir project"
complete -f -c mix -n '__fish_mix_using_command help' -a profile.fprof -d "Profiles the given file or expression with fprof"
complete -f -c mix -n '__fish_mix_using_command help' -a phx -d "Prints Phoenix tasks and their information."
complete -f -c mix -n '__fish_mix_using_command help' -a phx.digest -d "Digests and compresses static files"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.digest.clean -d "Removes old versions of static assets."
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen -d "Lists all available Phoenix generators"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.auth -d "Generates authentication logic for a resource"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.cert -d "Generates a self-signed certificate for HTTPS testing"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.channel -d "Generates a Phoenix channel"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.context -d "Generates a context with functions around an Ecto schema"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.embedded -d "Generates an embedded Ecto schema file"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.html -d "Generates context and controller for an HTML resource"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.json -d "Generates context and controller for a JSON resource"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.live -d "Generates LiveView, templates, and context for a resource"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.notifier -d "Generates a notifier that delivers emails by default"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.presence -d "Generates a Presence tracker"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.release -d "Generates release files and optional Dockerfile for release-based deployments"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.schema -d "Generates an Ecto schema and migration file"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.secret -d "Generates a secret"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.gen.socket -d "Generates a Phoenix socket handler"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.new -d "Creates a new Phoenix application"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.new.ecto -d "Creates a new Ecto project within an umbrella project"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.new.web -d "Creates a new Phoenix web project within an umbrella project"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.routes -d "Prints all routes"
complete -f -c mix -n '__fish_mix_using_command help' -a phx.server -d "Starts applications and their servers"
complete -f -c mix -n '__fish_mix_using_command help' -a run -d "Runs the given file or expression"
complete -f -c mix -n '__fish_mix_using_command help' -a test -d "Runs a project's tests"
