/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.InsertionRelation;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.ui.MouseEventActor;

public class NodeDropUtils {
    public static boolean isDragAcceptable(DropTargetDragEvent event, NodeModel targetNode, AcceptedContent acceptedContent) {
        return NodeDropUtils.checkDragAcceptability(event, targetNode, acceptedContent);
    }

    private static boolean isDraggingDuplicateTag(DropTargetDragEvent event, NodeModel targetNode) {
        if (!event.isDataFlavorSupported(TagSelection.tagFlavor)) {
            return false;
        }
        try {
            List<Tag> existingNodeTags = Controller.getCurrentModeController().getExtension(IconController.class).getTags(targetNode);
            String tagData = (String)event.getTransferable().getTransferData(TagSelection.tagFlavor);
            Tag draggedTag = TagCategories.readTag(tagData);
            return existingNodeTags.contains(draggedTag);
        }
        catch (UnsupportedFlavorException | IOException e) {
            return true;
        }
    }

    private static boolean containsFilesStringsImagesOrTags(DropTargetDragEvent event) {
        return event.isDataFlavorSupported(DataFlavor.stringFlavor) || event.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor) || event.isDataFlavorSupported(DataFlavor.imageFlavor) || event.isDataFlavorSupported(TagSelection.tagFlavor);
    }

    private static boolean containsTags(DropTargetDragEvent event) {
        return event.isDataFlavorSupported(TagSelection.tagFlavor);
    }

    private static boolean checkDragAcceptability(DropTargetDragEvent event, NodeModel targetNode, AcceptedContent acceptedContent) {
        if (NodeDropUtils.isDraggingDuplicateTag(event, targetNode)) {
            return false;
        }
        switch (acceptedContent.ordinal()) {
            case 0: {
                return NodeDropUtils.containsFilesStringsImagesOrTags(event);
            }
            case 1: {
                return NodeDropUtils.containsTags(event);
            }
        }
        return false;
    }

    public static boolean isDropAcceptable(DropTargetDropEvent event, NodeModel targetNode, int dropAction, AcceptedContent acceptedContent) {
        return NodeDropUtils.validateDropAcceptability(event, targetNode, dropAction, acceptedContent);
    }

    private static boolean validateDropAcceptability(DropTargetDropEvent event, NodeModel targetNode, int dropAction, AcceptedContent acceptedContent) {
        List<NodeModel> droppedNodes;
        boolean containsTags = event.isDataFlavorSupported(TagSelection.tagFlavor);
        if (acceptedContent == AcceptedContent.ONLY_TAGS && !containsTags) {
            return false;
        }
        if (!event.isLocalTransfer()) {
            return true;
        }
        if (containsTags) {
            try {
                List<Tag> nodeTags = Controller.getCurrentModeController().getExtension(IconController.class).getTags(targetNode);
                String tagData = (String)event.getTransferable().getTransferData(TagSelection.tagFlavor);
                Tag tag = TagCategories.readTag(tagData);
                if (nodeTags.contains(tag)) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        if (!event.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            return dropAction != 0x40000000;
        }
        try {
            Transferable t = event.getTransferable();
            droppedNodes = NodeDropUtils.getNodeObjects(t);
        }
        catch (Exception e) {
            return dropAction != 0x40000000;
        }
        if (dropAction == 0x40000000) {
            return NodeDropUtils.areFromSameMap(targetNode, droppedNodes);
        }
        if (dropAction == 2) {
            return !NodeDropUtils.isFromDescendantNode(targetNode, droppedNodes);
        }
        return !NodeDropUtils.droppedNodesContainTargetNode(targetNode, droppedNodes);
    }

    public static boolean canAcceptNodeTransfer(Transferable transferable, NodeModel targetNode, int dropAction) {
        if (!transferable.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            return dropAction != 0x40000000;
        }
        try {
            List<NodeModel> droppedNodes = NodeDropUtils.getNodeObjects(transferable);
            if (dropAction == 0x40000000) {
                return NodeDropUtils.areFromSameMap(targetNode, droppedNodes);
            }
            if (dropAction == 2) {
                return !NodeDropUtils.isFromDescendantNode(targetNode, droppedNodes);
            }
            return !NodeDropUtils.droppedNodesContainTargetNode(targetNode, droppedNodes);
        }
        catch (Exception e) {
            return dropAction != 0x40000000;
        }
    }

    public static boolean droppedNodesContainTargetNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected) continue;
            return true;
        }
        return false;
    }

    public static boolean areFromSameMap(NodeModel targetNode, Collection<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (selected.getMap() == targetNode.getMap()) continue;
            return false;
        }
        return true;
    }

    public static boolean areFromSameMap(Transferable transferable, NodeModel targetNode) throws UnsupportedFlavorException, IOException {
        List<NodeModel> draggedNodes = NodeDropUtils.getNodeObjects(transferable);
        return NodeDropUtils.areFromSameMap(targetNode, draggedNodes);
    }

    public static boolean isFromDescendantNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected && !targetNode.isDescendantOf(selected)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFromDescencantNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        return NodeDropUtils.isFromDescendantNode(targetNode, droppedNodes);
    }

    public static List<NodeModel> getNodeObjects(Transferable t) throws UnsupportedFlavorException, IOException {
        return (List)t.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
    }

    public static int getDropAction(Transferable t, int defaultDropAction) {
        int dropAction = defaultDropAction;
        if (t.isDataFlavorSupported(MindMapNodesSelection.dropCopyActionFlavor)) {
            dropAction = 1;
        } else if (t.isDataFlavorSupported(MindMapNodesSelection.dropLinkActionFlavor)) {
            dropAction = 0x40000000;
        }
        return dropAction;
    }

    public static int getDropAction(DropTargetDropEvent dtde) {
        return NodeDropUtils.getDropAction(dtde.getTransferable(), dtde.getDropAction());
    }

    public static void handleLinkAction(Transferable transferable, NodeModel targetNode, Controller controller, ModeController modeController) throws UnsupportedFlavorException, IOException {
        int yesorno = 0;
        if (controller.getSelection().size() >= 5) {
            yesorno = JOptionPane.showConfirmDialog(controller.getViewController().getCurrentRootComponent(), TextUtils.getText("lots_of_links_warning"), Integer.toString(controller.getSelection().size()) + " links to the same node", 0);
        }
        if (yesorno == 0) {
            for (NodeModel sourceNodeModel : NodeDropUtils.getNodeObjects(transferable)) {
                ((MLinkController)LinkController.getController(modeController)).addConnector(sourceNodeModel, targetNode);
            }
        }
    }

    public static void handleMoveOrCopyAction(Transferable transferable, NodeModel targetNode, int dropAction, boolean isLocalTransfer, InsertionRelation insertionRelation, NodeModel.Side side) throws UnsupportedFlavorException, IOException {
        MMapController mapController = (MMapController)Controller.getCurrentModeController().getMapController();
        if (2 == dropAction && isLocalTransfer && NodeDropUtils.areFromSameMap(transferable, targetNode)) {
            List<NodeModel> movedNodes = NodeDropUtils.getNodeObjects(transferable);
            MouseEventActor.INSTANCE.withMouseEvent(() -> {
                if (insertionRelation != InsertionRelation.AS_CHILD) {
                    mapController.moveNodes((List)movedNodes, targetNode, insertionRelation);
                    mapController.setSide((List)movedNodes, targetNode.getSide());
                } else {
                    List nodesChangingParent = movedNodes.stream().filter(node -> targetNode != node.getParentNode()).collect(Collectors.toList());
                    mapController.moveNodes((List)movedNodes, targetNode, insertionRelation);
                    mapController.setSide(nodesChangingParent.isEmpty() ? movedNodes : nodesChangingParent, side);
                }
            });
        } else if (1 == dropAction || 2 == dropAction) {
            ((MMapClipboardController)MapClipboardController.getController()).paste(transferable, targetNode, side, dropAction);
        }
    }

    public static enum AcceptedContent {
        ANY,
        ONLY_TAGS;

    }
}

