/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import java.util.Map;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class JavaFieldAccess
extends JavaAccess<AccessTarget.FieldAccessTarget> {
    private static final Map<AccessType, String> MESSAGE_VERB = ImmutableMap.of(AccessType.GET, "gets", AccessType.SET, "sets");
    private final AccessType accessType;

    JavaFieldAccess(DomainBuilders.JavaFieldAccessBuilder builder) {
        super(builder);
        this.accessType = Preconditions.checkNotNull(builder.getAccessType());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    protected String additionalToStringFields() {
        return ", accessType=" + (Object)((Object)this.accessType);
    }

    @Override
    protected String descriptionVerb() {
        return MESSAGE_VERB.get((Object)this.accessType);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static enum AccessType {
        GET(182),
        SET(183);

        private final int asmOpCodes;

        private AccessType(int asmOpCodes) {
            this.asmOpCodes = asmOpCodes;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static AccessType forOpCode(int opCode) {
            for (AccessType accessType : AccessType.values()) {
                if ((accessType.asmOpCodes & opCode) != opCode) continue;
                return accessType;
            }
            throw new IllegalArgumentException("There is no " + AccessType.class.getSimpleName() + " registered for OpCode <" + opCode + ">");
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaFieldAccess> accessType(AccessType accessType) {
            return new AccessTypePredicate(accessType);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaFieldAccess> target(DescribedPredicate<? super AccessTarget.FieldAccessTarget> predicate) {
            return new JavaAccess.Predicates.TargetPredicate(predicate);
        }

        private static class AccessTypePredicate
        extends DescribedPredicate<JavaFieldAccess> {
            private final AccessType accessType;

            AccessTypePredicate(AccessType accessType) {
                super("access type " + (Object)((Object)accessType), new Object[0]);
                this.accessType = accessType;
            }

            @Override
            public boolean test(JavaFieldAccess input) {
                return this.accessType == input.getAccessType();
            }
        }
    }
}

