/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaGenericArrayType;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.JavaWildcardType;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

class SignatureTraversal
implements JavaType.SignatureVisitor {
    private final Set<JavaType> visited = new HashSet<JavaType>();
    private final JavaType.SignatureVisitor delegate;
    private JavaType.SignatureVisitor.Result lastResult;

    private SignatureTraversal(JavaType.SignatureVisitor delegate) {
        this.delegate = delegate;
    }

    @Override
    public JavaType.SignatureVisitor.Result visitClass(JavaClass type) {
        Supplier getFurtherTypesToTraverse = this.visited.isEmpty() ? type::getTypeParameters : Collections::emptyList;
        return this.visit(type, this.delegate::visitClass, getFurtherTypesToTraverse);
    }

    @Override
    public JavaType.SignatureVisitor.Result visitParameterizedType(JavaParameterizedType type) {
        return this.visit(type, this.delegate::visitParameterizedType, type::getActualTypeArguments);
    }

    @Override
    public JavaType.SignatureVisitor.Result visitTypeVariable(JavaTypeVariable<?> type) {
        return this.visit(type, this.delegate::visitTypeVariable, type::getUpperBounds);
    }

    @Override
    public JavaType.SignatureVisitor.Result visitGenericArrayType(JavaGenericArrayType type) {
        return this.visit(type, this.delegate::visitGenericArrayType, () -> Collections.singleton(type.getComponentType()));
    }

    @Override
    public JavaType.SignatureVisitor.Result visitWildcardType(JavaWildcardType type) {
        return this.visit(type, this.delegate::visitWildcardType, () -> Iterables.concat(type.getUpperBounds(), type.getLowerBounds()));
    }

    private <CURRENT extends JavaType, NEXT extends JavaType> JavaType.SignatureVisitor.Result visit(CURRENT type, Function<CURRENT, JavaType.SignatureVisitor.Result> visitCurrent, Supplier<Iterable<NEXT>> nextTypes) {
        if (this.visited.contains(type)) {
            return this.setLast(JavaType.SignatureVisitor.Result.CONTINUE);
        }
        this.visited.add(type);
        if (visitCurrent.apply(type) == JavaType.SignatureVisitor.Result.CONTINUE) {
            JavaType.SignatureVisitor.Result result = this.visit(nextTypes.get());
            return this.setLast(result);
        }
        return this.setLast(JavaType.SignatureVisitor.Result.STOP);
    }

    private JavaType.SignatureVisitor.Result visit(Iterable<? extends JavaType> types) {
        for (JavaType javaType : types) {
            javaType.traverseSignature(this);
            if (this.lastResult != JavaType.SignatureVisitor.Result.STOP) continue;
            return JavaType.SignatureVisitor.Result.STOP;
        }
        return JavaType.SignatureVisitor.Result.CONTINUE;
    }

    private JavaType.SignatureVisitor.Result setLast(JavaType.SignatureVisitor.Result result) {
        this.lastResult = result;
        return result;
    }

    static SignatureTraversal from(JavaType.SignatureVisitor visitor) {
        return visitor instanceof SignatureTraversal ? (SignatureTraversal)visitor : new SignatureTraversal(visitor);
    }
}

