/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import java.util.Collection;

@PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
public abstract class ArchCondition<T> {
    private final String description;

    public ArchCondition(String description, Object ... args) {
        this.description = String.format(description, args);
    }

    public void init(Collection<T> allObjectsToTest) {
    }

    public abstract void check(T var1, ConditionEvents var2);

    public void finish(ConditionEvents events) {
    }

    public ArchCondition<T> and(ArchCondition<? super T> condition) {
        return ArchConditions.and(this, condition.forSubtype());
    }

    public ArchCondition<T> or(ArchCondition<? super T> condition) {
        return ArchConditions.or(this, condition.forSubtype());
    }

    public String getDescription() {
        return this.description;
    }

    public ArchCondition<T> as(String description, Object ... args) {
        return new ArchCondition<T>(description, args){

            @Override
            public void init(Collection<T> allObjectsToTest) {
                ArchCondition.this.init(allObjectsToTest);
            }

            @Override
            public void check(T item, ConditionEvents events) {
                ArchCondition.this.check(item, events);
            }

            @Override
            public void finish(ConditionEvents events) {
                ArchCondition.this.finish(events);
            }
        };
    }

    public String toString() {
        return this.getDescription();
    }

    public <U extends T> ArchCondition<U> forSubtype() {
        return this;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static <T extends HasDescription & HasSourceCodeLocation> ConditionByPredicate<T> from(DescribedPredicate<? super T> predicate) {
        return new ConditionByPredicate(predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class ConditionByPredicate<T extends HasDescription & HasSourceCodeLocation>
    extends ArchCondition<T> {
        private final DescribedPredicate<T> predicate;
        private final EventDescriber eventDescriber;

        private ConditionByPredicate(DescribedPredicate<? super T> predicate) {
            this(predicate, predicate.getDescription(), (String predicateDescription, boolean satisfied) -> (satisfied ? "satisfies " : "does not satisfy ") + predicateDescription);
        }

        private ConditionByPredicate(DescribedPredicate<? super T> predicate, String description, EventDescriber eventDescriber) {
            super(description, new Object[0]);
            this.predicate = predicate.forSubtype();
            this.eventDescriber = eventDescriber;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public ConditionByPredicate<T> describeEventsBy(EventDescriber eventDescriber) {
            return new ConditionByPredicate<T>(this.predicate, this.getDescription(), eventDescriber);
        }

        @Override
        public ConditionByPredicate<T> as(String description, Object ... args) {
            return new ConditionByPredicate<T>(this.predicate, String.format(description, args), this.eventDescriber);
        }

        @Override
        public <U extends T> ConditionByPredicate<U> forSubtype() {
            return this;
        }

        @Override
        public void check(T object, ConditionEvents events) {
            boolean satisfied = this.predicate.test(object);
            String message = ConditionEvent.createMessage(object, this.eventDescriber.describe(this.predicate.getDescription(), satisfied));
            events.add(new SimpleConditionEvent(object, satisfied, message));
        }

        @FunctionalInterface
        @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
        public static interface EventDescriber {
            public String describe(String var1, boolean var2);
        }
    }
}

