/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Dictionary;
import com.inet.jortho.LetterBasedBreakIterator;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Utils;
import java.text.BreakIterator;
import java.util.Locale;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class Tokenizer {
    private final Dictionary dictionary;
    private final Document doc;
    private int endOffset;
    private boolean isFirstWordInSentence;
    private final SpellCheckerOptions options;
    private int paragraphOffset;
    private String phrase;
    private String sentence;
    private final BreakIterator sentences;
    private int startSentence;
    private int endSentence;
    private int startWord;
    private int endWord;
    private int wordOffset;
    private final LetterBasedBreakIterator words;

    Tokenizer(JTextComponent jText, Dictionary dictionary, Locale locale, int startOffset, int endOffset, SpellCheckerOptions options) {
        this.dictionary = dictionary;
        this.doc = jText.getDocument();
        this.options = options == null ? SpellChecker.getOptions() : options;
        this.sentences = BreakIterator.getSentenceInstance(locale);
        this.words = new LetterBasedBreakIterator();
        this.paragraphOffset = startOffset;
        this.endOffset = endOffset;
        this.setSentencesText();
        this.endSentence = this.sentences.first();
        this.endWord = -1;
    }

    Tokenizer(JTextComponent jText, Dictionary dictionary, Locale locale, int offset, SpellCheckerOptions options) {
        this(jText, dictionary, locale, Utilities.getParagraphElement(jText, offset).getStartOffset(), Utilities.getParagraphElement(jText, offset).getEndOffset(), options);
    }

    Tokenizer(JTextComponent jText, Dictionary dictionary, Locale locale, SpellCheckerOptions options) {
        this(jText, dictionary, locale, 0, jText.getDocument().getLength(), options);
    }

    int getWordOffset() {
        return this.paragraphOffset + this.wordOffset;
    }

    boolean isFirstWordInSentence() {
        return this.isFirstWordInSentence;
    }

    private boolean isWebAddress(String word) {
        if (this.startWord + 2 >= this.sentence.length()) {
            return false;
        }
        char char0 = this.sentence.charAt(this.startWord);
        char char1 = this.sentence.charAt(this.startWord + 1);
        if (char0 == '@' && (Character.isLetter(char1) || Character.isDigit(char1)) || this.startWord + 3 < this.sentence.length() && char0 == ':' && char1 == '/' && this.sentence.charAt(this.startWord + 2) == '/') {
            String next;
            while (this.startWord < this.endWord && (next = this.sentence.substring(this.startWord, this.endWord).trim()).length() > 0) {
                word = word + next;
                this.startWord = this.endWord;
                this.endWord = this.words.next();
            }
            return true;
        }
        return false;
    }

    private void loadSentences() {
        this.setSentencesText();
        this.startSentence = this.sentences.first();
        this.endSentence = this.sentences.next();
        this.nextSentence();
    }

    public String nextInvalidWord() {
        this.isFirstWordInSentence = false;
        block0: while (true) {
            if (this.endWord == -1) {
                this.startSentence = this.endSentence;
                this.endSentence = this.sentences.next();
                if (this.endSentence == -1) {
                    if (!this.nextParagraph()) {
                        return null;
                    }
                } else {
                    this.nextSentence();
                }
            }
            while (true) {
                if (this.endWord == -1) continue block0;
                String word = this.sentence.substring(this.startWord, this.endWord).trim();
                this.wordOffset = this.startSentence + this.startWord;
                this.startWord = this.endWord;
                this.endWord = this.words.next();
                if (word.length() <= 1 || !Character.isLetter(word.charAt(0))) continue;
                boolean exist = this.dictionary.exist(word);
                if (!exist && !this.options.isCaseSensitive()) {
                    exist = this.dictionary.exist(Utils.getInvertedCapitalizion(word));
                } else if (!exist && (this.isFirstWordInSentence || this.options.getIgnoreCapitalization()) && Character.isUpperCase(word.charAt(0))) {
                    String capitalizeWord = word.substring(0, 1).toLowerCase() + word.substring(1);
                    exist = this.dictionary.exist(capitalizeWord);
                }
                if (!exist && this.options.isIgnoreAllCapsWords() && Utils.isAllCapitalized(word)) {
                    exist = true;
                }
                if (!exist && this.options.isIgnoreWordsWithNumbers() && Utils.isIncludeNumbers(word)) {
                    exist = true;
                }
                if (!exist && !this.isWebAddress(word)) {
                    return word;
                }
                this.isFirstWordInSentence = false;
            }
            break;
        }
    }

    private boolean nextParagraph() {
        if (this.doc instanceof AbstractDocument) {
            this.paragraphOffset = ((AbstractDocument)this.doc).getParagraphElement(this.paragraphOffset).getEndOffset();
            if (this.paragraphOffset >= this.endOffset) {
                return false;
            }
        } else {
            return false;
        }
        this.loadSentences();
        return true;
    }

    private void nextSentence() {
        this.sentence = this.phrase.substring(this.startSentence, this.endSentence);
        this.words.setText(this.sentence);
        this.startWord = this.words.first();
        this.endWord = this.words.next();
        this.isFirstWordInSentence = true;
    }

    private void setSentencesText() {
        int end = this.endOffset;
        if (this.doc instanceof AbstractDocument) {
            end = ((AbstractDocument)this.doc).getParagraphElement(this.paragraphOffset).getEndOffset();
        }
        try {
            this.phrase = this.doc.getText(this.paragraphOffset, end - this.paragraphOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.sentences.setText(this.phrase);
    }

    void updatePhrase() {
        this.endOffset = this.doc.getLength();
        this.setSentencesText();
        this.endSentence = this.sentences.following(this.startSentence);
        this.sentence = this.phrase.substring(this.startSentence, this.endSentence);
        this.words.setText(this.sentence);
        this.startWord = this.words.following(this.wordOffset);
        this.endWord = this.words.next();
    }
}

