/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.Fixed;
import jogamp.graph.font.typecast.ot.Fmt;

public class TableDirectory {
    private final int _version;
    private final short _numTables;
    private final short _searchRange;
    private final short _entrySelector;
    private final short _rangeShift;
    private final Entry[] _entries;

    public TableDirectory(DataInput dataInput) throws IOException {
        this._version = dataInput.readInt();
        this._numTables = dataInput.readShort();
        this._searchRange = dataInput.readShort();
        this._entrySelector = dataInput.readShort();
        this._rangeShift = dataInput.readShort();
        this._entries = new Entry[this._numTables];
        for (int i = 0; i < this._numTables; ++i) {
            this._entries[i] = new Entry(dataInput);
        }
    }

    public Entry getEntry(int n) {
        return this._entries[n];
    }

    public Entry getEntryByTag(int n) {
        for (int i = 0; i < this._numTables; ++i) {
            if (this._entries[i].getTag() != n) continue;
            return this._entries[i];
        }
        return null;
    }

    public short getEntrySelector() {
        return this._entrySelector;
    }

    public short getNumTables() {
        return this._numTables;
    }

    public short getRangeShift() {
        return this._rangeShift;
    }

    public short getSearchRange() {
        return this._searchRange;
    }

    public int getVersion() {
        return this._version;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Offset Table\n------ -----").append("\n  sfnt version:  ").append(Fixed.floatValue(this._version)).append("\n  numTables:     ").append(this._numTables).append("\n  searchRange:   ").append(this._searchRange).append("\n  entrySelector: ").append(this._entrySelector).append("\n  rangeShift:    ").append(this._rangeShift).append("\n\n");
        for (int i = 0; i < this._numTables; ++i) {
            stringBuilder.append("  ").append(Fmt.pad(2, i)).append(": ").append(this._entries[i].toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String toStringTag(int n) {
        return String.valueOf((char)(n >> 24 & 0xFF)) + (char)(n >> 16 & 0xFF) + (char)(n >> 8 & 0xFF) + (char)(n & 0xFF);
    }

    public static int fromStringTag(String string) {
        assert (string.length() == 4);
        return (string.charAt(0) & 0xFF) << 24 | (string.charAt(1) & 0xFF) << 16 | (string.charAt(2) & 0xFF) << 8 | string.charAt(3) & 0xFF;
    }

    public static class Entry {
        private final int _tag;
        private final int _checksum;
        private final int _offset;
        private final int _length;

        Entry(DataInput dataInput) throws IOException {
            this._tag = dataInput.readInt();
            this._checksum = dataInput.readInt();
            this._offset = dataInput.readInt();
            this._length = dataInput.readInt();
        }

        public int getChecksum() {
            return this._checksum;
        }

        public int getLength() {
            return this._length;
        }

        public int getOffset() {
            return this._offset;
        }

        int getTag() {
            return this._tag;
        }

        String getTagAsString() {
            int n = this._tag;
            return TableDirectory.toStringTag(n);
        }

        public String toString() {
            return "'" + this.getTagAsString() + "' - chksm = 0x" + Integer.toHexString(this._checksum) + ", off = 0x" + Integer.toHexString(this._offset) + ", len = " + this._length;
        }
    }
}

