/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxComponent;
import java.util.HashMap;
import java.util.Locale;

public class SyntaxParser {
    private static final HashMap<String, CSSValueSyntax.Category> catMap = new HashMap(23);
    private static final CSSValueSyntax universal;

    public static CSSValueSyntax createSimpleSyntax(String category) {
        CSSValueSyntax.Category cat = SyntaxParser.category(category = category.toLowerCase(Locale.ROOT));
        if (cat != null) {
            return new SyntaxComponent(category, cat);
        }
        return null;
    }

    public CSSValueSyntax parseSyntax(String def) throws CSSException {
        SyntaxComponent comp;
        int len = (def = def.trim()).length();
        if (len == 0 || len == 2) {
            SyntaxParser.errInvalidDefinition(def);
        }
        char c = def.charAt(0);
        if (len == 1) {
            if (c == '*') {
                return SyntaxParser.getUniversal();
            }
            SyntaxParser.errInvalidDefinition(def);
        }
        if (c == '|' || def.charAt(len - 1) == '|') {
            SyntaxParser.errInvalidDefinition(def);
        }
        SyntaxComponent current = comp = new SyntaxComponent();
        int idx = 0;
        block0: while ((idx = SyntaxParser.parseComponent(def, idx, current)) < len) {
            while (Character.isWhitespace(c = def.charAt(idx))) {
                if (++idx != len) continue;
                break block0;
            }
            if (c != '|') {
                SyntaxParser.errInvalidDefinition(def);
            }
            ++idx;
            while (Character.isWhitespace(c = def.charAt(idx))) {
                if (++idx != len) continue;
                break block0;
            }
            SyntaxComponent next = new SyntaxComponent();
            current.setNext(next);
            current = next;
        }
        return comp;
    }

    private static int parseComponent(String def, int idx, SyntaxComponent comp) throws CSSException {
        int cp;
        int len = def.length();
        while (Character.isWhitespace(cp = def.codePointAt(idx))) {
            if (++idx != len) continue;
            return len;
        }
        if (cp == 60) {
            idx = SyntaxParser.parseDataType(def, idx + 1, comp);
        } else if (SyntaxParser.isNameStartCharOrEsc(cp) || cp == 45) {
            idx = SyntaxParser.parseIdent(def, idx, comp);
        } else {
            throw new CSSException("Unexpected character at definition, index " + idx + ": '" + def + '\'');
        }
        return idx;
    }

    private static int parseDataType(String def, int idx, SyntaxComponent comp) throws CSSException {
        int cp;
        int len = def.length();
        boolean escaped = false;
        int i = idx;
        while ((cp = def.codePointAt(i)) != 62) {
            i = def.offsetByCodePoints(i, 1);
            if (cp == 92) {
                escaped = true;
                continue;
            }
            if (SyntaxParser.isNameChar(cp) && i != len) continue;
            SyntaxParser.errInvalidDefinition(def);
        }
        if (i == idx) {
            SyntaxParser.errInvalidDefinition(def);
        }
        String name = def.substring(idx, i);
        if (escaped) {
            name = ParseHelper.unescapeStringValue(name);
        }
        name = name.toLowerCase(Locale.ROOT);
        comp.setName(name);
        CSSValueSyntax.Category cat = SyntaxParser.category(name);
        if (cat == null) {
            SyntaxParser.errUnknownDataType(name, def);
        }
        comp.setCategory(cat);
        if (++i < len) {
            char c = def.charAt(i);
            if (c == '#') {
                comp.setMultiplier(CSSValueSyntax.Multiplier.NUMBER);
                ++i;
            } else if (c == '+') {
                comp.setMultiplier(CSSValueSyntax.Multiplier.PLUS);
                ++i;
            }
        }
        return i;
    }

    private static CSSValueSyntax.Category category(String name) {
        return catMap.get(name);
    }

    private static int parseIdent(String def, int idx, SyntaxComponent comp) throws CSSException {
        int len = def.length();
        int i = idx;
        int escapeIndex = -2;
        while (i < len) {
            int cp = def.codePointAt(i);
            if (cp == 92) {
                escapeIndex = escapeIndex == i - 1 ? -2 : i;
                ++i;
                continue;
            }
            if (!SyntaxParser.isNameChar(cp)) {
                if (escapeIndex == -2 || cp != 32 && i != escapeIndex + 1) break;
                escapeIndex = -2;
                ++i;
                continue;
            }
            if (escapeIndex != -2 && !ParseHelper.isHexCodePoint(cp)) {
                escapeIndex = -2;
            }
            i = def.offsetByCodePoints(i, 1);
        }
        if (i == idx + 1) {
            SyntaxParser.errInvalidDefinition(def);
        }
        String name = def.substring(idx, i);
        name = ParseHelper.unescapeStringValue(name);
        comp.setName(name);
        comp.setCategory(CSSValueSyntax.Category.IDENT);
        if (i < len) {
            char c = def.charAt(i);
            if (c == '#') {
                comp.setMultiplier(CSSValueSyntax.Multiplier.NUMBER);
                ++i;
            } else if (c == '+') {
                comp.setMultiplier(CSSValueSyntax.Multiplier.PLUS);
                ++i;
            }
        }
        return i;
    }

    private static void errInvalidDefinition(String def) throws CSSException {
        throw new CSSException("Invalid definition: '" + def + '\'');
    }

    private static void errUnknownDataType(String name, String def) {
        throw new CSSException("Unknown data type '" + name + "' in definition: " + def);
    }

    private static boolean isNameStartCharOrEsc(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 128 || c == 92 || c == 95;
    }

    private static boolean isNameChar(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c >= 128 || c == 95 || c == 45;
    }

    static CSSValueSyntax getUniversal() {
        return universal;
    }

    static {
        catMap.put("angle", CSSValueSyntax.Category.angle);
        catMap.put("color", CSSValueSyntax.Category.color);
        catMap.put("custom-ident", CSSValueSyntax.Category.customIdent);
        catMap.put("image", CSSValueSyntax.Category.image);
        catMap.put("integer", CSSValueSyntax.Category.integer);
        catMap.put("length", CSSValueSyntax.Category.length);
        catMap.put("length-percentage", CSSValueSyntax.Category.lengthPercentage);
        catMap.put("number", CSSValueSyntax.Category.number);
        catMap.put("percentage", CSSValueSyntax.Category.percentage);
        catMap.put("resolution", CSSValueSyntax.Category.resolution);
        catMap.put("time", CSSValueSyntax.Category.time);
        catMap.put("unicode-range", CSSValueSyntax.Category.unicodeRange);
        catMap.put("easing-function", CSSValueSyntax.Category.easingFunction);
        catMap.put("transform-function", CSSValueSyntax.Category.transformFunction);
        catMap.put("transform-list", CSSValueSyntax.Category.transformList);
        catMap.put("url", CSSValueSyntax.Category.url);
        catMap.put("string", CSSValueSyntax.Category.string);
        catMap.put("counter", CSSValueSyntax.Category.counter);
        catMap.put("frequency", CSSValueSyntax.Category.frequency);
        catMap.put("flex", CSSValueSyntax.Category.flex);
        catMap.put("basic-shape", CSSValueSyntax.Category.basicShape);
        universal = new SyntaxComponent("*", CSSValueSyntax.Category.universal);
    }
}

