/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.UnitProcessor;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.gvt.text.TextPath;
import io.sf.carte.echosvg.parser.AWTPathProducer;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PathHandler;
import io.sf.carte.echosvg.parser.PathParser;
import io.sf.carte.echosvg.parser.UnitProcessor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Element;

public class SVGTextPathElementBridge
extends AnimatableGenericSVGBridge
implements ErrorConstants {
    @Override
    public String getLocalName() {
        return "textPath";
    }

    @Override
    public void handleElement(BridgeContext ctx, Element e) {
    }

    public TextPath createTextPath(BridgeContext ctx, Element textPathElement) {
        String uri = XLinkSupport.getXLinkHref((Element)textPathElement);
        Element pathElement = ctx.getReferencedElement(textPathElement, uri);
        if (pathElement == null || !"http://www.w3.org/2000/svg".equals(pathElement.getNamespaceURI()) || !pathElement.getLocalName().equals("path")) {
            throw new BridgeException(ctx, textPathElement, "uri.badTarget", new Object[]{uri});
        }
        String s = pathElement.getAttributeNS(null, "d");
        Shape pathShape = null;
        if (s.length() != 0) {
            AWTPathProducer app = new AWTPathProducer();
            app.setWindingRule(CSSUtilities.convertFillRule(pathElement));
            try {
                PathParser pathParser = new PathParser((PathHandler)app);
                pathParser.parse(s);
            }
            catch (ParseException pEx) {
                throw new BridgeException(ctx, pathElement, (Exception)((Object)pEx), "attribute.malformed", new Object[]{"d"});
            }
            finally {
                pathShape = app.getShape();
            }
        } else {
            throw new BridgeException(ctx, pathElement, "attribute.missing", new Object[]{"d"});
        }
        s = pathElement.getAttributeNS(null, "transform");
        if (s.length() != 0) {
            AffineTransform tr = SVGUtilities.convertTransform(pathElement, "transform", s, ctx);
            pathShape = tr.createTransformedShape(pathShape);
        }
        TextPath textPath = new TextPath(new GeneralPath(pathShape));
        s = textPathElement.getAttributeNS(null, "startOffset");
        if (s.length() > 0) {
            float startOffset = 0.0f;
            int percentIndex = s.indexOf(37);
            if (percentIndex != -1) {
                float pathLength = textPath.lengthOfPath();
                String percentString = s.substring(0, percentIndex);
                float startOffsetPercent = 0.0f;
                try {
                    startOffsetPercent = SVGUtilities.convertSVGNumber(percentString);
                }
                catch (NumberFormatException e) {
                    throw new BridgeException(ctx, textPathElement, "attribute.malformed", new Object[]{"startOffset", s});
                }
                startOffset = startOffsetPercent * pathLength / 100.0f;
            } else {
                UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, textPathElement);
                startOffset = UnitProcessor.svgOtherLengthToUserSpace(s, "startOffset", uctx);
            }
            textPath.setStartOffset(startOffset);
        }
        return textPath;
    }
}

