/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.plugin.ColumnUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.TempDirUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class GraphDistance
implements Statistics,
LongTask {
    public static final String BETWEENNESS = "betweenesscentrality";
    public static final String CLOSENESS = "closnesscentrality";
    public static final String HARMONIC_CLOSENESS = "harmonicclosnesscentrality";
    public static final String ECCENTRICITY = "eccentricity";
    private double[] betweenness;
    private double[] closeness;
    private double[] harmonicCloseness;
    private double[] eccentricity;
    private int diameter;
    private int radius;
    private double avgDist;
    private int N;
    private boolean isDirected;
    private ProgressTicket progress;
    private boolean isCanceled;
    private boolean isNormalized;

    public GraphDistance() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    public double getPathLength() {
        return this.avgDist;
    }

    public double getDiameter() {
        return this.diameter;
    }

    public double getRadius() {
        return this.radius;
    }

    public void execute(GraphModel graphModel) {
        Object graph = this.isDirected ? graphModel.getDirectedGraphVisible() : graphModel.getUndirectedGraphVisible();
        this.execute((Graph)graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Graph graph) {
        this.isCanceled = false;
        this.initializeAttributeColunms(graph.getModel());
        graph.readLock();
        try {
            this.N = graph.getNodeCount();
            this.initializeStartValues();
            HashMap<Node, Integer> indicies = this.createIndiciesMap(graph);
            Map<String, double[]> metrics = this.calculateDistanceMetrics(graph, indicies, this.isDirected, this.isNormalized);
            this.eccentricity = metrics.get(ECCENTRICITY);
            this.closeness = metrics.get(CLOSENESS);
            this.harmonicCloseness = metrics.get(HARMONIC_CLOSENESS);
            this.betweenness = metrics.get(BETWEENNESS);
            this.saveCalculatedValues(graph, indicies, this.eccentricity, this.betweenness, this.closeness, this.harmonicCloseness);
        }
        finally {
            graph.readUnlock();
        }
    }

    public Map<String, double[]> calculateDistanceMetrics(Graph graph, HashMap<Node, Integer> indicies, boolean directed, boolean normalized) {
        int n = graph.getNodeCount();
        HashMap<String, double[]> metrics = new HashMap<String, double[]>();
        double[] nodeEccentricity = new double[n];
        double[] nodeBetweenness = new double[n];
        double[] nodeCloseness = new double[n];
        double[] nodeHarmonicCloseness = new double[n];
        metrics.put(ECCENTRICITY, nodeEccentricity);
        metrics.put(CLOSENESS, nodeCloseness);
        metrics.put(HARMONIC_CLOSENESS, nodeHarmonicCloseness);
        metrics.put(BETWEENNESS, nodeBetweenness);
        Progress.start((ProgressTicket)this.progress, (int)graph.getNodeCount());
        int count = 0;
        int totalPaths = 0;
        NodeIterable nodesIterable = graph.getNodes();
        for (Node s : nodesIterable) {
            Stack<Node> S = new Stack<Node>();
            LinkedList[] P = new LinkedList[n];
            double[] theta = new double[n];
            int[] d = new int[n];
            int s_index = indicies.get(s);
            this.setInitParametetrsForNode(s, P, theta, d, s_index, n);
            LinkedList<Node> Q = new LinkedList<Node>();
            Q.addLast(s);
            while (!Q.isEmpty()) {
                Node v = (Node)Q.removeFirst();
                S.push(v);
                int v_index = indicies.get(v);
                EdgeIterable edgeIter = this.getEdgeIter(graph, v, directed);
                for (Edge edge : edgeIter) {
                    Node reachable = graph.getOpposite(v, edge);
                    int r_index = indicies.get(reachable);
                    if (d[r_index] < 0) {
                        Q.addLast(reachable);
                        d[r_index] = d[v_index] + 1;
                    }
                    if (d[r_index] != d[v_index] + 1) continue;
                    theta[r_index] = theta[r_index] + theta[v_index];
                    P[r_index].addLast(v);
                }
            }
            double reachable = 0.0;
            for (int i = 0; i < n; ++i) {
                if (d[i] <= 0) continue;
                this.avgDist += (double)d[i];
                nodeEccentricity[s_index] = (int)Math.max(nodeEccentricity[s_index], (double)d[i]);
                int n2 = s_index;
                nodeCloseness[n2] = nodeCloseness[n2] + (double)d[i];
                int n3 = s_index;
                nodeHarmonicCloseness[n3] = nodeHarmonicCloseness[n3] + (Double.isInfinite(d[i]) ? 0.0 : 1.0 / (double)d[i]);
                this.diameter = Math.max(this.diameter, d[i]);
                reachable += 1.0;
            }
            this.radius = (int)Math.min(nodeEccentricity[s_index], (double)this.radius);
            if (reachable != 0.0) {
                nodeCloseness[s_index] = nodeCloseness[s_index] == 0.0 ? 0.0 : reachable / nodeCloseness[s_index];
                nodeHarmonicCloseness[s_index] = nodeHarmonicCloseness[s_index] / reachable;
            }
            totalPaths = (int)((double)totalPaths + reachable);
            double[] delta = new double[n];
            while (!S.empty()) {
                Node w = (Node)S.pop();
                int w_index = indicies.get(w);
                ListIterator iter1 = P[w_index].listIterator();
                while (iter1.hasNext()) {
                    int u_index;
                    Node u = (Node)iter1.next();
                    int n4 = u_index = indicies.get(u).intValue();
                    delta[n4] = delta[n4] + theta[u_index] / theta[w_index] * (1.0 + delta[w_index]);
                }
                if (w == s) continue;
                int n5 = w_index;
                nodeBetweenness[n5] = nodeBetweenness[n5] + delta[w_index];
            }
            ++count;
            if (this.isCanceled) {
                nodesIterable.doBreak();
                return metrics;
            }
            Progress.progress((ProgressTicket)this.progress, (int)count);
        }
        this.avgDist /= (double)totalPaths;
        this.calculateCorrection(graph, indicies, nodeBetweenness, directed, normalized);
        return metrics;
    }

    private void setInitParametetrsForNode(Node s, LinkedList<Node>[] P, double[] theta, int[] d, int index, int n) {
        for (int j = 0; j < n; ++j) {
            P[j] = new LinkedList();
            theta[j] = 0.0;
            d[j] = -1;
        }
        theta[index] = 1.0;
        d[index] = 0;
    }

    private EdgeIterable getEdgeIter(Graph graph, Node v, boolean directed) {
        EdgeIterable edgeIter = directed ? ((DirectedGraph)graph).getOutEdges(v) : graph.getEdges(v);
        return edgeIter;
    }

    private void initializeAttributeColunms(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        ColumnUtils.cleanUpColumns(nodeTable, new String[]{ECCENTRICITY, CLOSENESS, HARMONIC_CLOSENESS, BETWEENNESS}, Double.class);
        if (!nodeTable.hasColumn(ECCENTRICITY)) {
            nodeTable.addColumn(ECCENTRICITY, "Eccentricity", Double.class, (Object)new Double(0.0));
        }
        if (!nodeTable.hasColumn(CLOSENESS)) {
            nodeTable.addColumn(CLOSENESS, "Closeness Centrality", Double.class, (Object)new Double(0.0));
        }
        if (!nodeTable.hasColumn(HARMONIC_CLOSENESS)) {
            nodeTable.addColumn(HARMONIC_CLOSENESS, "Harmonic Closeness Centrality", Double.class, (Object)new Double(0.0));
        }
        if (!nodeTable.hasColumn(BETWEENNESS)) {
            nodeTable.addColumn(BETWEENNESS, "Betweenness Centrality", Double.class, (Object)new Double(0.0));
        }
    }

    public HashMap<Node, Integer> createIndiciesMap(Graph graph) {
        HashMap<Node, Integer> indicies = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : graph.getNodes()) {
            indicies.put(s, index);
            ++index;
        }
        return indicies;
    }

    public void initializeStartValues() {
        this.betweenness = new double[this.N];
        this.eccentricity = new double[this.N];
        this.closeness = new double[this.N];
        this.harmonicCloseness = new double[this.N];
        this.diameter = 0;
        this.avgDist = 0.0;
        this.radius = Integer.MAX_VALUE;
    }

    public double computeBetweennessNormalizationFactor(int nodeCount) {
        return ((double)nodeCount - 1.0) * ((double)nodeCount - 2.0);
    }

    private void calculateCorrection(Graph graph, HashMap<Node, Integer> indicies, double[] nodeBetweenness, boolean directed, boolean normalized) {
        int n = graph.getNodeCount();
        for (Node s : graph.getNodes()) {
            int s_index = indicies.get(s);
            if (!directed) {
                int n2 = s_index;
                nodeBetweenness[n2] = nodeBetweenness[n2] / 2.0;
            }
            if (!normalized) continue;
            double betweennessNormalizationFactor = this.computeBetweennessNormalizationFactor(n);
            if (!directed) {
                betweennessNormalizationFactor /= 2.0;
            }
            int n3 = s_index;
            nodeBetweenness[n3] = nodeBetweenness[n3] / betweennessNormalizationFactor;
        }
    }

    private void saveCalculatedValues(Graph graph, HashMap<Node, Integer> indicies, double[] nodeEccentricity, double[] nodeBetweenness, double[] nodeCloseness, double[] nodeHarmonicCloseness) {
        for (Node s : graph.getNodes()) {
            int s_index = indicies.get(s);
            s.setAttribute(ECCENTRICITY, (Object)nodeEccentricity[s_index]);
            s.setAttribute(CLOSENESS, (Object)nodeCloseness[s_index]);
            s.setAttribute(HARMONIC_CLOSENESS, (Object)nodeHarmonicCloseness[s_index]);
            s.setAttribute(BETWEENNESS, (Object)nodeBetweenness[s_index]);
        }
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public void setNormalized(boolean isNormalized) {
        this.isNormalized = isNormalized;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    private String createImageFile(TempDirUtils.TempDir tempDir, double[] pVals, String pName, String pX, String pY) {
        HashMap<Double, Integer> dist = new HashMap<Double, Integer>();
        for (int i = 0; i < this.N; ++i) {
            Double d = pVals[i];
            if (dist.containsKey(d)) {
                Integer v = (Integer)dist.get(d);
                dist.put(d, v + 1);
                continue;
            }
            dist.put(d, 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(dist, pName);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)pName, (String)pX, (String)pY, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, this.isNormalized);
        return ChartUtils.renderChart(chart, pName + ".png");
    }

    public String getReport() {
        String htmlIMG1 = "";
        String htmlIMG2 = "";
        String htmlIMG3 = "";
        String htmlIMG4 = "";
        try {
            TempDirUtils.TempDir tempDir = TempDirUtils.createTempDir();
            htmlIMG1 = this.createImageFile(tempDir, this.betweenness, "Betweenness Centrality Distribution", "Value", "Count");
            htmlIMG2 = this.createImageFile(tempDir, this.closeness, "Closeness Centrality Distribution", "Value", "Count");
            htmlIMG3 = this.createImageFile(tempDir, this.harmonicCloseness, "Harmonic Closeness Centrality Distribution", "Value", "Count");
            htmlIMG4 = this.createImageFile(tempDir, this.eccentricity, "Eccentricity Distribution", "Value", "Count");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String report = "<HTML> <BODY> <h1>Graph Distance  Report </h1> <hr><br><h2> Parameters: </h2>Network Interpretation:  " + (this.isDirected ? "directed" : "undirected") + "<br /><br /> <h2> Results: </h2>Diameter: " + this.diameter + "<br />Radius: " + this.radius + "<br />Average Path length: " + this.avgDist + "<br />" + htmlIMG1 + "<br /><br />" + htmlIMG2 + "<br /><br />" + htmlIMG3 + "<br /><br />" + htmlIMG4 + "<br /><br /><h2> Algorithm: </h2>Ulrik Brandes, <i>A Faster Algorithm for Betweenness Centrality</i>, in Journal of Mathematical Sociology 25(2):163-177, (2001)<br /></BODY> </HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

