/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.io.File;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.localization.LocalizationSupport;

final class IllegalCharactersInFileNameValidator
extends StringValidator {
    IllegalCharactersInFileNameValidator() {
    }

    @Override
    public void validate(Problems problems, String compName, String text) {
        boolean invalid;
        boolean bl = invalid = text.contains(File.separator) || text.contains(File.pathSeparator);
        if (!invalid && IllegalCharactersInFileNameValidator.isWindows()) {
            invalid = text.contains(":");
        }
        if (invalid) {
            problems.append(LocalizationSupport.getMessage(IllegalCharactersInFileNameValidator.class, "ERR_INVALID_FILE_NAME", compName, text));
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

