/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.utils;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public final class WhiteFilter
extends RGBImageFilter {
    private final float[] hsv = new float[3];

    public WhiteFilter() {
        this.canFilterIndexColorModel = true;
    }

    public static Image createDisabledImage(Image i) {
        WhiteFilter filter = new WhiteFilter();
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int transparency = rgb >> 24 & 0xFF;
        if (transparency <= 1) {
            return rgb;
        }
        Color.RGBtoHSB(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb >> 0 & 0xFF, this.hsv);
        this.hsv[1] = 0.0f;
        return Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]) + ((transparency /= 2) << 24);
    }
}

