/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.processor.spi.Scaler;

public class DefaultScaler
implements Scaler {
    private float sizeMinimum;
    private float sizeMaximum;
    private float weightMinimum;
    private float weightMaximum;
    private float octreeLimit;

    private void setDefaults() {
        this.sizeMaximum = 100.0f;
        this.sizeMinimum = 4.0f;
        this.weightMinimum = 0.4f;
        this.weightMaximum = 2.0f;
        this.octreeLimit = 5000.0f;
    }

    public void doScale(Container container) {
        this.setDefaults();
        float sizeMin = Float.POSITIVE_INFINITY;
        float sizeMax = Float.NEGATIVE_INFINITY;
        float xMin = Float.POSITIVE_INFINITY;
        float xMax = Float.NEGATIVE_INFINITY;
        float yMin = Float.POSITIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        float zMin = Float.POSITIVE_INFINITY;
        float zMax = Float.NEGATIVE_INFINITY;
        float sizeRatio = 0.0f;
        float averageSize = 2.5f;
        double centroidX = 0.0;
        double centroidY = 0.0;
        int nodeSize = 0;
        for (NodeDraft node : container.getUnloader().getNodes()) {
            centroidX += (double)node.getX();
            centroidY += (double)node.getY();
            ++nodeSize;
        }
        centroidX /= (double)nodeSize;
        centroidY /= (double)nodeSize;
        for (NodeDraft node : container.getUnloader().getNodes()) {
            node.setX((float)((double)node.getX() - centroidX));
            node.setY((float)((double)node.getY() - centroidY));
        }
        for (NodeDraft node : container.getUnloader().getNodes()) {
            sizeMin = Math.min(node.getSize(), sizeMin);
            sizeMax = Math.max(node.getSize(), sizeMax);
            xMin = Math.min(node.getX(), xMin);
            xMax = Math.max(node.getX(), xMax);
            yMin = Math.min(node.getY(), yMin);
            yMax = Math.max(node.getY(), yMax);
            zMin = Math.min(node.getZ(), zMin);
            zMax = Math.max(node.getZ(), zMax);
        }
        if (sizeMin != 0.0f && sizeMax != 0.0f) {
            sizeRatio = sizeMin == sizeMax ? this.sizeMinimum / sizeMin : (this.sizeMaximum - this.sizeMinimum) / (sizeMax - sizeMin);
            if (xMin * sizeRatio < -this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / xMin);
            }
            if (xMax * sizeRatio > this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / xMax);
            }
            if (yMin * sizeRatio < -this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / yMin);
            }
            if (yMax * sizeRatio > this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / yMax);
            }
            if (zMin * sizeRatio < -this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / zMin);
            }
            if (zMax * sizeRatio > this.octreeLimit) {
                sizeRatio = Math.abs(this.octreeLimit / zMax);
            }
            averageSize = 0.0f;
            for (NodeDraft node : container.getUnloader().getNodes()) {
                float size = (node.getSize() - sizeMin) * sizeRatio + this.sizeMinimum;
                node.setSize(size);
                node.setX(node.getX() * sizeRatio);
                node.setY(node.getY() * sizeRatio);
                node.setZ(node.getZ() * sizeRatio);
                averageSize += size;
            }
            averageSize /= (float)nodeSize;
        }
    }
}

