/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.graph.api.GraphController;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXLabel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HitsPanel
extends JPanel {
    private JRadioButton directedRadioButton;
    private JTextField epsilonTextField;
    private JRadioButton undirectedRadioButton;
    private JXLabel descriptionLabel;
    private ButtonGroup directedButtonGroup;
    private JXLabel epsilonLabel;
    private JXHeader header;
    private JLabel labelEpsilon;

    public HitsPanel() {
        this.initComponents();
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController.getGraphModel().isUndirected()) {
            this.directedRadioButton.setEnabled(false);
        }
    }

    public boolean isDirected() {
        return this.directedRadioButton.isSelected();
    }

    public void setDirected(boolean directed) {
        this.directedButtonGroup.setSelected(directed ? this.directedRadioButton.getModel() : this.undirectedRadioButton.getModel(), true);
        if (!directed) {
            this.directedRadioButton.setEnabled(false);
        }
    }

    public double getEpsilon() {
        try {
            return Double.parseDouble(this.epsilonTextField.getText());
        }
        catch (Exception exception) {
            return 1.0E-4;
        }
    }

    public void setEpsilon(double epsilon) {
        this.epsilonTextField.setText(Double.toString(epsilon));
    }

    private void initComponents() {
        this.directedButtonGroup = new ButtonGroup();
        this.labelEpsilon = new JLabel();
        this.epsilonTextField = new JTextField();
        this.undirectedRadioButton = new JRadioButton();
        this.directedRadioButton = new JRadioButton();
        this.descriptionLabel = new JXLabel();
        this.header = new JXHeader();
        this.epsilonLabel = new JXLabel();
        this.labelEpsilon.setText(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.labelEpsilon.text"));
        this.epsilonTextField.setText(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.epsilonTextField.text"));
        this.epsilonTextField.setMinimumSize(new Dimension(59, 25));
        this.epsilonTextField.setPreferredSize(new Dimension(59, 25));
        this.directedButtonGroup.add(this.undirectedRadioButton);
        this.undirectedRadioButton.setText(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.undirectedRadioButton.text"));
        this.directedButtonGroup.add(this.directedRadioButton);
        this.directedRadioButton.setText(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.directedRadioButton.text"));
        this.descriptionLabel.setText(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.descriptionLabel.text"));
        this.descriptionLabel.setVerticalAlignment(1);
        this.descriptionLabel.setLineWrap(true);
        this.header.setDescription(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.header.description"));
        this.header.setTitle(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.header.title"));
        this.epsilonLabel.setForeground(new Color(102, 102, 102));
        this.epsilonLabel.setText(NbBundle.getMessage(HitsPanel.class, (String)"HitsPanel.epsilonLabel.text"));
        this.epsilonLabel.setFont(this.epsilonLabel.getFont().deriveFont((float)this.epsilonLabel.getFont().getSize() - 1.0f));
        this.epsilonLabel.setLineWrap(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.header, -2, 662, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.descriptionLabel, -1, 622, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.directedRadioButton).addComponent(this.undirectedRadioButton)).addGap(92, 92, 92).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.labelEpsilon).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.epsilonTextField, -2, -1, -2).addGap(143, 143, 143)).addComponent((Component)this.epsilonLabel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.header, -2, -1, -2).addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directedRadioButton).addComponent(this.labelEpsilon).addComponent(this.epsilonTextField, -2, -1, -2)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.undirectedRadioButton).addComponent((Component)this.epsilonLabel, -2, -1, -2)).addGap(59, 59, 59).addComponent((Component)this.descriptionLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }
}

