/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Bundle;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.RequestProcessor;

public class ModuleInstallerSupport {
    private static RequestProcessor RP = new RequestProcessor(ModuleInstallerSupport.class.getName(), 1);
    private static final Logger LOG = Logger.getLogger(ModuleInstallerSupport.class.getName());
    private final Object[] closingOptions;
    private Object[] fullClosingOptions;
    private JButton tryAgain;
    private JButton proxySettings;

    public ModuleInstallerSupport(Object ... alternativeOptions) {
        this.closingOptions = (Object[])alternativeOptions.clone();
    }

    public Object installPlugins(String displayName, Set<String> cnbs) throws OperationException {
        Collection<UpdateUnit> units = this.findModules(cnbs);
        if (units == null) {
            String searchMessage = displayName != null ? Bundle.searching_handle_single(displayName) : Bundle.searching_handle();
            final String resolveTitle = displayName != null ? Bundle.resolve_title_single(displayName) : Bundle.resolve_title();
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)searchMessage);
            this.initButtons();
            final DialogDescriptor searching = new DialogDescriptor((Object)ModuleInstallerSupport.searchingPanel(new JLabel(searchMessage), ProgressHandleFactory.createProgressComponent((ProgressHandle)handle)), resolveTitle, true, null);
            handle.setInitialDelay(0);
            handle.start();
            searching.setOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
            searching.setMessageType(-1);
            final Dialog dlg = DialogDisplayer.getDefault().createDialog(searching);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                                p.refresh(handle, true);
                            }
                            dlg.dispose();
                        }
                        catch (IOException ex) {
                            LOG.log(Level.FINE, ex.getMessage(), ex);
                            if (!dlg.isVisible()) {
                                LOG.fine("dialog not visible => do nothing");
                                return;
                            }
                            DialogDescriptor networkProblem = new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(resolveTitle, Bundle.networkproblem_message()), Bundle.networkproblem_header(), true, null);
                            networkProblem.setOptions(new Object[]{ModuleInstallerSupport.this.tryAgain, ModuleInstallerSupport.this.proxySettings, NotifyDescriptor.CANCEL_OPTION});
                            networkProblem.setAdditionalOptions(ModuleInstallerSupport.this.closingOptions);
                            networkProblem.setClosingOptions(ModuleInstallerSupport.this.fullClosingOptions);
                            networkProblem.setMessageType(2);
                            Dialog networkProblemDialog = DialogDisplayer.getDefault().createDialog(networkProblem);
                            networkProblemDialog.setVisible(true);
                            Object answer = networkProblem.getValue();
                            if (NotifyDescriptor.CANCEL_OPTION.equals(answer) || Arrays.asList(ModuleInstallerSupport.this.closingOptions).contains(answer) || answer.equals(-1)) {
                                LOG.fine("cancel network problem dialog");
                                searching.setValue(answer);
                                dlg.dispose();
                            }
                            if (ModuleInstallerSupport.this.tryAgain.equals(answer)) {
                                LOG.fine("try again searching");
                                RP.post((Runnable)this);
                            }
                            if ($assertionsDisabled) break block6;
                            throw new AssertionError((Object)("Unknown " + answer));
                        }
                    }
                }
            });
            dlg.setVisible(true);
            handle.finish();
            if (NotifyDescriptor.CANCEL_OPTION.equals(searching.getValue()) || searching.getValue().equals(-1)) {
                LOG.log(Level.FINE, "user canceled searching for {0}", cnbs);
                return this.showNoDownloadDialog(displayName, cnbs);
            }
            if (Arrays.asList(this.closingOptions).contains(searching.getValue())) {
                return searching.getValue();
            }
            units = this.findModules(cnbs);
            if (units == null) {
                LOG.log(Level.FINE, "could not find {0} on any update site", cnbs);
                return this.showNoDownloadDialog(displayName, cnbs);
            }
        }
        ArrayList<UpdateUnit> toHandle = new ArrayList<UpdateUnit>(units);
        OperationContainer oc = null;
        Iterator it = toHandle.iterator();
        while (it.hasNext()) {
            UpdateUnit unit = (UpdateUnit)it.next();
            if (unit.getInstalled() == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(unit.getInstalled() + " already installed. Is active? " + unit.getInstalled().isEnabled());
            }
            if (unit.getInstalled().isEnabled()) {
                it.remove();
                continue;
            }
            if (oc == null) {
                oc = OperationContainer.createForEnable();
            }
            if (!oc.canBeAdded(unit, unit.getInstalled())) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, "could not add " + unit.getInstalled() + " for activation");
            }
            for (UpdateElement req : oc.add(unit.getInstalled()).getRequiredElements()) {
                oc.add(req);
            }
            it.remove();
        }
        if (oc != null) {
            ProgressHandle activeHandle = ProgressHandleFactory.createHandle((String)(displayName != null ? Bundle.active_handle_single(displayName) : Bundle.active_handle()));
            OperationSupport.Restarter restarter = ((OperationSupport)oc.getSupport()).doOperation(activeHandle);
            assert (restarter == null) : "No Restater need to make units active";
        }
        if (toHandle.isEmpty()) {
            return null;
        }
        OperationContainer ocInstall = OperationContainer.createForInstall();
        Iterator it2 = toHandle.iterator();
        while (it2.hasNext()) {
            UpdateUnit unit = (UpdateUnit)it2.next();
            List updates = unit.getAvailableUpdates();
            if (updates.isEmpty()) {
                throw new OperationException(OperationException.ERROR_TYPE.INSTALL, "no updates for " + unit);
            }
            UpdateElement element = (UpdateElement)updates.get(0);
            if (!ocInstall.canBeAdded(unit, element)) {
                throw new OperationException(OperationException.ERROR_TYPE.INSTALL, "could not add " + element + " to updates");
            }
            for (UpdateElement req : ocInstall.add(element).getRequiredElements()) {
                ocInstall.add(req);
            }
            it2.remove();
        }
        assert (toHandle.isEmpty()) : "These unit were not handled " + toHandle;
        if (!PluginManager.openInstallWizard((OperationContainer<InstallSupport>)ocInstall)) {
            LOG.fine("user canceled PM");
            return this.showNoDownloadDialog(displayName, cnbs);
        }
        return null;
    }

    private Collection<UpdateUnit> findModules(Set<String> cnbs) {
        ArrayList<UpdateUnit> ret = new ArrayList<UpdateUnit>(cnbs.size());
        for (UpdateUnit unit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!cnbs.contains(unit.getCodeName())) continue;
            ret.add(unit);
            if (ret.size() != cnbs.size()) continue;
            break;
        }
        if (ret.size() == cnbs.size()) {
            return ret;
        }
        return null;
    }

    private void initButtons() {
        if (this.tryAgain != null) {
            return;
        }
        this.tryAgain = new JButton();
        this.proxySettings = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.tryAgain, (String)Bundle.tryagain_button());
        Mnemonics.setLocalizedText((AbstractButton)this.proxySettings, (String)Bundle.proxy_button());
        this.proxySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.fine("show proxy options");
                OptionsDisplayer.getDefault().open("General");
            }
        });
        this.fullClosingOptions = new Object[this.closingOptions.length + 2];
        System.arraycopy(this.closingOptions, 0, this.fullClosingOptions, 0, this.closingOptions.length);
        this.fullClosingOptions[this.fullClosingOptions.length - 2] = this.tryAgain;
        this.fullClosingOptions[this.fullClosingOptions.length - 1] = NotifyDescriptor.CANCEL_OPTION;
    }

    private Object showNoDownloadDialog(String displayName, Set<String> cnbs) throws OperationException {
        DialogDescriptor networkProblem = displayName != null ? new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(Bundle.nodownload_header_single(displayName), Bundle.nodownload_message_single(displayName)), Bundle.resolve_title_single(displayName), true, null) : new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(Bundle.nodownload_header(), Bundle.nodownload_message()), Bundle.resolve_title(), true, null);
        this.initButtons();
        networkProblem.setOptions(new Object[]{this.tryAgain, NotifyDescriptor.CANCEL_OPTION});
        networkProblem.setAdditionalOptions(this.closingOptions);
        networkProblem.setClosingOptions(this.fullClosingOptions);
        networkProblem.setMessageType(2);
        Dialog networkProblemDialog = DialogDisplayer.getDefault().createDialog(networkProblem);
        networkProblemDialog.setVisible(true);
        Object answer = networkProblem.getValue();
        if (NotifyDescriptor.CANCEL_OPTION.equals(answer) || Arrays.asList(this.closingOptions).contains(answer) || answer.equals(-1)) {
            LOG.fine("cancel no download dialog");
            return answer;
        }
        if (this.tryAgain.equals(answer)) {
            LOG.fine("try again download()");
            return this.installPlugins(displayName, cnbs);
        }
        assert (false) : "Unknown " + answer;
        assert (false) : "Unknown " + answer;
        return -1;
    }

    private static JPanel searchingPanel(JLabel progressLabel, JComponent progressComponent) {
        JPanel panel = new JPanel();
        progressLabel.setLabelFor(progressComponent);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(progressLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(progressComponent, GroupLayout.Alignment.LEADING, -1, 399, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(96, 96, 96).addComponent(progressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(progressComponent, -2, -1, -2).addContainerGap(109, Short.MAX_VALUE)));
        return panel;
    }

    private static JPanel problemPanel(String header, String message) {
        JPanel panel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        JTextArea jTextArea1 = new JTextArea();
        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | 1));
        jLabel1.setText(header);
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setRows(5);
        jTextArea1.setText(message);
        jTextArea1.setOpaque(false);
        jScrollPane1.setViewportView(jTextArea1);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 478, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(jLabel1).addGap(107, 107, 107))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 133, Short.MAX_VALUE).addGap(82, 82, 82)));
        return panel;
    }
}

