---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token CircleCI Personal Access Token'
---

## Description

The response body contains content that matches the pattern of a CircleCI personal access token was identified. Personal access tokens grant the same level of permissions as the user that created the token. A malicious actor with access to this token can impersonate the user and gain access to all features and services in CircleCI.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

For rotating a Personal Access token:

- In the CircleCI application, go to your User settings.
- Select "Personal API Tokens".
- Select "X" in the Remove column for the token you wish to replace and confirm your deletion. - Select "Create New Token".
- In the Token name field, type a new name for the old token you are rotating. It can be the same name given to the old token.
- Select "Add API Token".
- After the token appears, copy and paste it to another location. It is not possible to view the token again.

For more information please see their [documentation on rotating personal access tokens](https://circleci.com/docs/managing-api-tokens/#rotating-a-personal-api-token).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.132 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
