/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.FileInfo;
import tim.prune.data.FileType;
import tim.prune.data.TrackInfo;
import tim.prune.gui.DialogCloser;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.ProgressDialog;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.SettingsForExport;
import tim.prune.save.VersionCombiner;
import tim.prune.save.xml.GpxWriter;
import tim.prune.save.xml.GpxWriter10;
import tim.prune.save.xml.GpxWriter11;
import tim.prune.save.xml.XmlUtils;

public class GpxExporter
extends GenericFunction {
    private final TrackInfo _trackInfo;
    private JDialog _dialog = null;
    private JComboBox<String> _titleField = null;
    private JComboBox<String> _descriptionField = null;
    private JComboBox<String> _versionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JCheckBox _timestampsCheckbox = null;
    private JCheckBox _descsToCommentsCheckbox = null;
    private JPanel _encodingsPanel = null;
    private JRadioButton _useSystemRadio = null;
    private JRadioButton _forceUtf8Radio = null;
    private File _exportFile = null;
    private boolean _cancelled = false;
    private ProgressDialog _progress = null;

    public GpxExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
    }

    @Override
    public String getNameKey() {
        return "function.exportgpx";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._pointTypeSelector.init(this._app.getTrackInfo());
        this._encodingsPanel.setVisible(!XmlUtils.isSystemUtf8());
        if (!XmlUtils.isSystemUtf8()) {
            String string = XmlUtils.getSystemEncoding();
            this._useSystemRadio.setText(String.valueOf(I18nManager.getText("dialog.exportgpx.encoding.system")) + " (" + (string == null ? "unknown" : string) + ")");
        }
        this.populateComboboxes();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        Serializable serializable;
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = new JPanel();
        double[] dArray = new double[]{0.2, 0.8};
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] blArray2 = blArray;
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel4, dArray, blArray2);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.exportgpx.name")));
        this._titleField = new JComboBox();
        this._titleField.setPrototypeDisplayValue("Long enough for a reasonable description");
        this._titleField.setEditable(true);
        guiGridLayout.add(this._titleField);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.exportgpx.desc")));
        this._descriptionField = new JComboBox();
        this._descriptionField.setPrototypeDisplayValue("Long enough for a reasonable description");
        this._descriptionField.setEditable(true);
        guiGridLayout.add(this._descriptionField);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.exportxml.version")));
        this._versionField = new JComboBox();
        this._versionField.setPrototypeDisplayValue("Long enough for a reasonable description");
        this._versionField.setEditable(false);
        guiGridLayout.add(this._versionField);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createVerticalStrut(15));
        this._pointTypeSelector = new PointTypeSelector();
        jPanel3.add(this._pointTypeSelector);
        jPanel3.add(Box.createVerticalStrut(15));
        JPanel jPanel5 = new JPanel();
        dArray = new double[]{0.5, 0.5};
        blArray2 = new boolean[2];
        GuiGridLayout guiGridLayout2 = new GuiGridLayout(jPanel5, dArray, blArray2);
        this._timestampsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.includetimestamps"));
        this._timestampsCheckbox.setSelected(true);
        guiGridLayout2.add(this._timestampsCheckbox);
        this._descsToCommentsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.descriptionstocomments"));
        guiGridLayout2.add(this._descsToCommentsCheckbox, 2, true);
        jPanel3.add(jPanel5);
        this._encodingsPanel = new JPanel();
        if (!XmlUtils.isSystemUtf8()) {
            this._encodingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this._encodingsPanel.setLayout(new BorderLayout());
            this._encodingsPanel.add((Component)new JLabel(I18nManager.getText("dialog.exportgpx.encoding")), "North");
            jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            serializable = new ButtonGroup();
            this._useSystemRadio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.system"));
            this._forceUtf8Radio = new JRadioButton(I18nManager.getText("dialog.exportgpx.encoding.utf8"));
            ((ButtonGroup)serializable).add(this._useSystemRadio);
            ((ButtonGroup)serializable).add(this._forceUtf8Radio);
            jPanel.add(this._useSystemRadio);
            jPanel.add(this._forceUtf8Radio);
            this._useSystemRadio.setSelected(true);
            this._encodingsPanel.add((Component)jPanel, "Center");
            jPanel3.add(this._encodingsPanel);
        }
        jPanel2.add((Component)jPanel3, "Center");
        this._titleField.addKeyListener(new DialogCloser(this._dialog));
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        serializable = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> this.startExport();
        ((AbstractButton)serializable).addActionListener(actionListener);
        jPanel.add((Component)serializable);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel.add(jButton);
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel2;
    }

    private void populateComboboxes() {
        FileInfo fileInfo = this._app.getTrackInfo().getFileInfo();
        GpxExporter.populateCombobox(this._titleField, fileInfo.getAllTitles());
        GpxExporter.populateCombobox(this._descriptionField, fileInfo.getAllDescriptions());
        this._versionField.removeAllItems();
        boolean bl = fileInfo.hasExtensions(FileType.GPX);
        this._versionField.addItem(I18nManager.getText("dialog.exportgpx.version10" + (bl ? "withextensions" : "")));
        this._versionField.addItem(I18nManager.getText("dialog.exportgpx.version11" + (bl ? "withextensions" : "")));
        boolean bl2 = this.shouldExportGpx10(fileInfo);
        this._versionField.setSelectedIndex(bl2 ? 0 : 1);
    }

    private boolean shouldExportGpx10(FileInfo fileInfo) {
        VersionCombiner versionCombiner = new VersionCombiner(List.of("1.0", "1.1"));
        for (String string : fileInfo.getVersions(FileType.GPX)) {
            versionCombiner.addVersion(string);
        }
        return versionCombiner.getBestVersion().equals("1.0");
    }

    private static void populateCombobox(JComboBox<String> jComboBox, List<String> list) {
        String string = GpxExporter.getEnteredText(jComboBox);
        jComboBox.removeAllItems();
        for (String string2 : list) {
            jComboBox.addItem(string2);
        }
        if (string.isEmpty() && jComboBox.getItemCount() > 0) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(string);
        }
    }

    private void startExport() {
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        String string = this.getConfig().getConfigString("prune.trackdirectory");
        File file = GpxExporter.chooseGpxFile(this._parentFrame, this.getEnteredName(), string);
        if (file != null) {
            this._exportFile = file;
            this._cancelled = false;
            this._progress = new ProgressDialog(this._parentFrame, this.getNameKey(), null, () -> {
                boolean bl = this._cancelled = true;
            });
            this._progress.show();
            new Thread(this::run).start();
            this._dialog.dispose();
        }
    }

    public static File chooseGpxFile(JFrame jFrame, String string, String string2) {
        String string3;
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new GenericFileFilter("filetypefilter.gpx", new String[]{"gpx"}));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (string2 != null) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        if ((string3 = GpxExporter.makeFilenameFromTrackName(string)) != null) {
            jFileChooser.setSelectedFile(new File(string3));
        }
        boolean bl = false;
        do {
            bl = false;
            if (jFileChooser.showSaveDialog(jFrame) != 0) continue;
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getName().toLowerCase().endsWith(".gpx")) {
                file2 = new File(String.valueOf(file2.getAbsolutePath()) + ".gpx");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file2.exists() || JOptionPane.showOptionDialog(jFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                file = file2;
                continue;
            }
            bl = true;
        } while (bl);
        return file;
    }

    private static String makeFilenameFromTrackName(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.equals("")) {
            return null;
        }
        if ((string2 = string2.replaceAll(" ", "_")).length() > 20) {
            string2 = string2.substring(0, 20);
        }
        if (!string2.toLowerCase().endsWith(".gpx")) {
            string2 = String.valueOf(string2) + ".gpx";
        }
        return string2;
    }

    public void run() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = this._forceUtf8Radio != null && this._forceUtf8Radio.isSelected() ? new OutputStreamWriter((OutputStream)new FileOutputStream(this._exportFile), StandardCharsets.UTF_8) : new OutputStreamWriter(new FileOutputStream(this._exportFile));
            SettingsForExport settingsForExport = new SettingsForExport();
            settingsForExport.setExportTrackPoints(this._pointTypeSelector.getTrackpointsSelected());
            settingsForExport.setExportWaypoints(this._pointTypeSelector.getWaypointsSelected());
            settingsForExport.setExportPhotoPoints(this._pointTypeSelector.getPhotopointsSelected());
            settingsForExport.setExportAudiopoints(this._pointTypeSelector.getAudiopointsSelected());
            settingsForExport.setExportJustSelection(this._pointTypeSelector.getJustSelection());
            settingsForExport.setExportTimestamps(this._timestampsCheckbox.isSelected());
            settingsForExport.setCopyDescriptionsToComments(this._descsToCommentsCheckbox.isSelected());
            String string = this.getEnteredName();
            String string2 = this.getEnteredDescription();
            boolean bl = this._versionField.getSelectedIndex() == 0;
            GpxWriter gpxWriter = bl ? new GpxWriter10(this._progress, settingsForExport) : new GpxWriter11(this._progress, settingsForExport);
            int n = gpxWriter.exportData(outputStreamWriter, this._trackInfo, string, string2, this._app.getTrackInfo().getFileInfo());
            outputStreamWriter.close();
            this._progress.close();
            if (this._cancelled) {
                UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.cancelled"));
                return;
            }
            this.getConfig().setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            this._app.addRecentFile(this._exportFile, true);
            UpdateMessageBroker.informSubscribers();
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._app.informDataSaved();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    private String getEnteredName() {
        return GpxExporter.getEnteredText(this._titleField);
    }

    private String getEnteredDescription() {
        return GpxExporter.getEnteredText(this._descriptionField);
    }

    private static String getEnteredText(JComboBox<String> jComboBox) {
        Object object = jComboBox.getSelectedItem();
        return object == null ? "" : object.toString();
    }
}

