/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorUInt32
extends AbstractList<Long>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorUInt32(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorUInt32 vectorUInt32) {
        return vectorUInt32 == null ? 0L : vectorUInt32.swigCPtr;
    }

    protected static long swigRelease(VectorUInt32 vectorUInt32) {
        long l = 0L;
        if (vectorUInt32 != null) {
            if (!vectorUInt32.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorUInt32.swigCPtr;
            vectorUInt32.swigCMemOwn = false;
            vectorUInt32.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorUInt32(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorUInt32(long[] lArray) {
        this();
        this.doReserve(lArray.length);
        for (long l : lArray) {
            this.doAdd(l);
        }
    }

    public VectorUInt32(Iterable<Long> iterable) {
        this();
        for (long l : iterable) {
            this.doAdd(l);
        }
    }

    @Override
    public Long get(int n) {
        return this.doGet(n);
    }

    @Override
    public Long set(int n, Long l) {
        return this.doSet(n, l);
    }

    @Override
    public boolean add(Long l) {
        ++this.modCount;
        this.doAdd(l);
        return true;
    }

    @Override
    public void add(int n, Long l) {
        ++this.modCount;
        this.doAdd(n, l);
    }

    @Override
    public Long remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorUInt32() {
        this(SimpleITKJNI.new_VectorUInt32__SWIG_0(), true);
    }

    public VectorUInt32(VectorUInt32 vectorUInt32) {
        this(SimpleITKJNI.new_VectorUInt32__SWIG_1(VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorUInt32_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorUInt32_clear(this.swigCPtr, this);
    }

    public VectorUInt32(int n, long l) {
        this(SimpleITKJNI.new_VectorUInt32__SWIG_2(n, l), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorUInt32_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorUInt32_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorUInt32_doSize(this.swigCPtr, this);
    }

    private void doAdd(long l) {
        SimpleITKJNI.VectorUInt32_doAdd__SWIG_0(this.swigCPtr, this, l);
    }

    private void doAdd(int n, long l) {
        SimpleITKJNI.VectorUInt32_doAdd__SWIG_1(this.swigCPtr, this, n, l);
    }

    private long doRemove(int n) {
        return SimpleITKJNI.VectorUInt32_doRemove(this.swigCPtr, this, n);
    }

    private long doGet(int n) {
        return SimpleITKJNI.VectorUInt32_doGet(this.swigCPtr, this, n);
    }

    private long doSet(int n, long l) {
        return SimpleITKJNI.VectorUInt32_doSet(this.swigCPtr, this, n, l);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorUInt32_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

