/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.autofilter;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.Logging;

public class AutoFilterRule {
    private static final BooleanProperty PROP_AUTO_FILTER_DEFAULTS = new BooleanProperty("auto.filter.defaults", true);
    private final String key;
    private final int minZoomLevel;
    private Function<OsmPrimitive, IntStream> defaultValueSupplier = p -> IntStream.empty();
    private ToIntFunction<String> valueExtractor = Integer::parseInt;
    private IntFunction<String> valueFormatter = Integer::toString;

    public AutoFilterRule(String key, int minZoomLevel) {
        this.key = key;
        this.minZoomLevel = minZoomLevel;
    }

    public String getKey() {
        return this.key;
    }

    public int getMinZoomLevel() {
        return this.minZoomLevel;
    }

    public String formatValue(int value) {
        return this.valueFormatter.apply(value);
    }

    public AutoFilterRule setValueFormatter(IntFunction<String> valueFormatter) {
        this.valueFormatter = Objects.requireNonNull(valueFormatter);
        return this;
    }

    public AutoFilterRule setDefaultValueSupplier(Function<OsmPrimitive, IntStream> defaultValueSupplier) {
        this.defaultValueSupplier = Objects.requireNonNull(defaultValueSupplier);
        return this;
    }

    public AutoFilterRule setValueExtractor(ToIntFunction<String> valueExtractor) {
        this.valueExtractor = Objects.requireNonNull(valueExtractor);
        return this;
    }

    public IntStream getTagValuesForPrimitive(OsmPrimitive osm) {
        String value = osm.get(this.key);
        if (value != null) {
            Pattern p = Pattern.compile("(-?[0-9]+)-(-?[0-9]+)");
            return OsmUtils.splitMultipleValues(value).flatMapToInt(v -> {
                Matcher m = p.matcher((CharSequence)v);
                if (m.matches()) {
                    int a = this.valueExtractor.applyAsInt(m.group(1));
                    int b = this.valueExtractor.applyAsInt(m.group(2));
                    return IntStream.rangeClosed(Math.min(a, b), Math.max(a, b));
                }
                try {
                    return IntStream.of(this.valueExtractor.applyAsInt((String)v));
                }
                catch (NumberFormatException e) {
                    Logging.trace(e);
                    return IntStream.empty();
                }
            });
        }
        return Boolean.TRUE.equals(PROP_AUTO_FILTER_DEFAULTS.get()) ? this.defaultValueSupplier.apply(osm) : IntStream.empty();
    }

    public static AutoFilterRule[] defaultRules() {
        return new AutoFilterRule[]{new AutoFilterRule("admin_level", 11), new AutoFilterRule("building:levels", 17), new AutoFilterRule("frequency", 5), new AutoFilterRule("gauge", 5), new AutoFilterRule("incline", 13).setValueExtractor(s -> Integer.parseInt(s.replaceAll("%$", ""))).setValueFormatter(v -> v + "\u2009%"), new AutoFilterRule("lanes", 13), new AutoFilterRule("layer", 16).setDefaultValueSupplier(AutoFilterRule::defaultLayer), new AutoFilterRule("level", 17).setValueExtractor(s -> (int)(Double.parseDouble(s) * 2.0)).setValueFormatter(v -> DecimalFormat.getInstance(Locale.ROOT).format((double)v / 2.0)), new AutoFilterRule("maxspeed", 16).setValueExtractor(s -> Integer.parseInt(s.replace(" mph", ""))), new AutoFilterRule("voltage", 5).setValueFormatter(s -> s % 1000 == 0 ? s / 1000 + "kV" : s + "V")};
    }

    static Optional<AutoFilterRule> getDefaultRule(String key) {
        return Arrays.stream(AutoFilterRule.defaultRules()).filter(r -> key.equals(r.getKey())).findFirst();
    }

    private static IntStream defaultLayer(OsmPrimitive osm) {
        if (osm.hasTag("bridge") || osm.hasTag("power", "line") || osm.hasTag("location", "overhead")) {
            return IntStream.of(1);
        }
        if (osm.isKeyTrue("tunnel") || osm.hasTag("tunnel", "culvert") || osm.hasTag("location", "underground")) {
            return IntStream.of(-1);
        }
        if (osm.hasTag("tunnel", "building_passage") || osm.hasKey("highway", "railway", "waterway")) {
            return IntStream.of(0);
        }
        return IntStream.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoFilterRule that = (AutoFilterRule)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return this.key + " [" + this.minZoomLevel + "]";
    }
}

