/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jruby.RubyFile;
import org.jruby.util.cli.Options;

class JarCache {
    private final Map<String, SoftJarIndex> indexCache = new ConcurrentHashMap<String, SoftJarIndex>();
    private final ReferenceQueue<JarIndex> indexQueue = new ReferenceQueue();

    JarCache() {
    }

    public JarIndex getIndex(String jarPath) {
        JarIndex index2;
        String cacheKey = jarPath;
        this.cleanup();
        SoftReference indexRef = this.indexCache.get(cacheKey);
        JarIndex jarIndex = index2 = indexRef == null ? null : (JarIndex)indexRef.get();
        if (index2 != null && !index2.isValid()) {
            index2 = null;
        }
        if (index2 == null) {
            try {
                index2 = new JarIndex(jarPath);
                this.indexCache.put(cacheKey, new SoftJarIndex(cacheKey, index2));
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return index2;
    }

    public void remove(String jarPath) {
        this.indexCache.remove(jarPath);
    }

    private void cleanup() {
        SoftJarIndex indexRef;
        while ((indexRef = (SoftJarIndex)this.indexQueue.poll()) != null) {
            this.indexCache.remove(indexRef.getKey());
        }
    }

    static class JarIndex {
        private static final String ROOT_KEY = "";
        private final Map<String, String[]> cachedDirEntries;
        private final JarFile jar;
        private final long lastModified;
        private Long lastModifiedExpiration;

        JarIndex(String jarPath) throws IOException {
            this.jar = new JarFile(jarPath);
            this.lastModified = this.getLastModified(jarPath);
            HashMap mutableCache = new HashMap();
            mutableCache.put(ROOT_KEY, new HashSet());
            Enumeration<JarEntry> entries2 = this.jar.entries();
            while (entries2.hasMoreElements()) {
                int lastPathSep;
                JarEntry entry = entries2.nextElement();
                String path2 = entry.getName();
                while ((lastPathSep = path2.lastIndexOf(47)) != -1) {
                    String entryPath;
                    String dirPath = path2.substring(0, lastPathSep);
                    HashSet<String> paths = (HashSet<String>)mutableCache.get(dirPath);
                    if (paths == null) {
                        paths = new HashSet<String>();
                        mutableCache.put(dirPath, paths);
                    }
                    if ((entryPath = path2.substring(lastPathSep + 1)).length() > 0) {
                        paths.add(entryPath);
                    }
                    path2 = dirPath;
                }
                ((HashSet)mutableCache.get(ROOT_KEY)).add(path2);
            }
            HashMap<String, String[]> cachedDirEntries = new HashMap<String, String[]>(mutableCache.size() + 8, 1.0f);
            for (Map.Entry entry : mutableCache.entrySet()) {
                Set value2 = (Set)entry.getValue();
                cachedDirEntries.put((String)entry.getKey(), value2.toArray(new String[value2.size()]));
            }
            this.cachedDirEntries = Collections.unmodifiableMap(cachedDirEntries);
        }

        private long getLastModified(String jarPath) {
            long currentTimeMillis = System.currentTimeMillis();
            if (this.lastModifiedExpiration != null && currentTimeMillis < this.lastModifiedExpiration) {
                return this.lastModified;
            }
            this.lastModifiedExpiration = currentTimeMillis + (long)Options.JAR_CACHE_EXPIRATION.load().intValue();
            return new File(jarPath).lastModified();
        }

        public JarEntry getJarEntry(String entryPath) {
            return this.jar.getJarEntry(JarIndex.canonicalJarPath(entryPath));
        }

        public String[] getDirEntries(String entryPath) {
            return this.cachedDirEntries.get(JarIndex.canonicalJarPath(entryPath));
        }

        public InputStream getInputStream(JarEntry entry) throws IOException, IllegalStateException {
            return this.jar.getInputStream(entry);
        }

        public void release() {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isValid() {
            return this.getLastModified(this.jar.getName()) <= this.lastModified;
        }

        private static String canonicalJarPath(String path2) {
            String canonical = RubyFile.canonicalize(path2);
            if (canonical.startsWith("/") && !path2.startsWith("/")) {
                canonical = canonical.substring(1);
            }
            return canonical;
        }
    }

    private static class SoftJarIndex
    extends SoftReference<JarIndex> {
        private final String key;

        public SoftJarIndex(String key2, JarIndex index2) {
            super(index2);
            this.key = key2;
        }

        public String getKey() {
            return this.key;
        }
    }
}

