/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.sf.juife.JuifeUtils;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.JSProgress;
import org.jsampler.view.std.StdI18n;

public class JSProgressDlg
extends JDialog
implements JSProgress {
    private final JPanel mainPane = new JPanel();
    private final JLabel l = new JLabel(" ");
    private JProgressBar pb = new JProgressBar();
    private final JButton btnCancel = new JButton(StdI18n.i18n.getButtonLabel("cancel"));

    public JSProgressDlg() {
        super((Frame)null, "", true);
        this.pb.setIndeterminate(true);
        this.l.setAlignmentX(0.5f);
        this.pb.setAlignmentX(0.5f);
        this.btnCancel.setAlignmentX(0.5f);
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 1));
        this.mainPane.add(this.l);
        this.mainPane.add(Box.createRigidArea(new Dimension(0, 6)));
        this.mainPane.add(this.pb);
        this.mainPane.add(Box.createRigidArea(new Dimension(0, 17)));
        this.mainPane.add(this.btnCancel);
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.add(this.mainPane);
        this.setDefaultCloseOperation(0);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSProgressDlg.this.onCancel();
            }
        });
        Dimension dimension = this.getPreferredSize();
        dimension.width = dimension.width > 300 ? dimension.width : 300;
        this.setPreferredSize(dimension);
        this.pack();
        this.setResizable(false);
        this.setLocation(JuifeUtils.centerLocation(this, CC.getMainFrame()));
    }

    private void onCancel() {
        Object object;
        int n = CC.getTaskQueue().getPendingTaskCount();
        if (n > 0) {
            object = n == 1 ? StdI18n.i18n.getMessage("JSProgressDlg.cancel?") : StdI18n.i18n.getMessage("JSProgressDlg.cancel2?", n);
            if (!HF.showYesNoDialog(CC.getMainFrame(), (String)object)) {
                CC.getTaskQueue().start();
                return;
            }
        }
        CC.getTaskQueue().removePendingTasks();
        object = CC.getTaskQueue().getRunningTask();
        if (object != null) {
            object.stop();
        }
        this.setVisible(false);
    }

    @Override
    public void setString(String string) {
        this.l.setText(string);
    }

    private void initProgressDlg() {
        this.pack();
        Dimension dimension = this.getPreferredSize();
        dimension.width = dimension.width > 300 ? dimension.width : 300;
        this.setSize(dimension);
        this.setResizable(false);
        this.setLocation(JuifeUtils.centerLocation(this, CC.getMainFrame()));
    }

    @Override
    public void start() {
        this.setLocation(JuifeUtils.centerLocation(this, CC.getMainFrame()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSProgressDlg.this.initProgressDlg();
                JSProgressDlg.this.setVisible(true);
            }
        });
    }

    @Override
    public void stop() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSProgressDlg.this.dispose();
            }
        });
    }
}

