/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dv!B\r\u001b\u0011\u0003yb!B\u0011\u001b\u0011\u0003\u0011\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0016\u0002\t\u0003ac\u0001B\u0011\u001b\u0001}B\u0001b\u0011\u0003\u0003\u0006\u0004%I\u0001\u0012\u0005\t\u0017\u0012\u0011\t\u0011)A\u0005\u000b\"AQ\u0007\u0002BC\u0002\u0013%A\n\u0003\u0005Q\t\t\u0005\t\u0015!\u0003N\u0011!\tFA!b\u0001\n\u0013\u0011\u0006\u0002C-\u0005\u0005\u0003\u0005\u000b\u0011B*\t\u0011i#!Q1A\u0005\nmC\u0001b\u001a\u0003\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tQ\u0012\u0011)\u0019!C\u0005S\"A\u0011\u0010\u0002B\u0001B\u0003%!\u000eC\u0003*\t\u0011\u0005!\u0010C\u0004\u0002\u0004\u0011!\t&!\u0002\t\u000f\u0005eA\u0001\"\u0003\u0002\u001c!9\u0011q\u0004\u0003\u0005R\u0005\u0005\u0002bBA\u001d\t\u0011\u0005\u00131\b\u0005\b\u0003K\"A\u0011AA4\u0011\u001d\t)\u0007\u0002C\u0001\u0003gBq!a#\u0005\t\u0003\ti\tC\u0004\u0002\f\u0012!\t!a%\t\u000f\u0005]E\u0001\"\u0001\u0002\u001a\u0006q2i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0006\u00037q\taa]3sm\u0016\u0014(\"A\u000f\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001%A\u0007\u00025\tq2i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/Y'b]\u0006<WM]\n\u0003\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 \u00039!\bN]8ui2,G+[7f\u001bN$\"!\f\u0019\u0011\u0005\u0011r\u0013BA\u0018&\u0005\u0011auN\\4\t\u000bE\u001a\u0001\u0019\u0001\u001a\u0002\u0003\u0015\u0004\"aM\u001f\u000e\u0003QR!!\u000e\u001c\u0002\u000f5,GO]5dg*\u0011q\u0007O\u0001\u0007G>lWn\u001c8\u000b\u0005uI$B\u0001\u001e<\u0003\u0019\t\u0007/Y2iK*\tA(A\u0002pe\u001eL!A\u0010\u001b\u0003/E+x\u000e^1WS>d\u0017\r^5p]\u0016C8-\u001a9uS>t7C\u0001\u0003A!\t\u0001\u0013)\u0003\u0002C5\t\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019wN\u001c4jOV\tQ\t\u0005\u0002G\u00136\tqI\u0003\u0002D\u0011*\u00111\u0004O\u0005\u0003\u0015\u001e\u0013\u0001d\u00117jK:$\u0018+^8uC6\u000bg.Y4fe\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002*\u0012!\u0014\t\u0003g9K!a\u0014\u001b\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0003uS6,W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y3\u0014!B;uS2\u001c\u0018B\u0001-V\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&DX#\u0001/\u0011\u0005u#gB\u00010c!\tyV%D\u0001a\u0015\t\tg$\u0001\u0004=e>|GOP\u0005\u0003G\u0016\na\u0001\u0015:fI\u00164\u0017BA3g\u0005\u0019\u0019FO]5oO*\u00111-J\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013!D9v_R\f7)\u00197mE\u0006\u001c7.F\u0001k!\r!3.\\\u0005\u0003Y\u0016\u0012aa\u00149uS>t\u0007c\u00018rg6\tqN\u0003\u0002qm\u0005I\u0011N\u001c;fe:\fGn]\u0005\u0003e>\u0014a\u0001\u00157vO&t\u0007C\u0001;x\u001b\u0005)(B\u0001<I\u0003\u0015\tXo\u001c;b\u0013\tAXOA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7.\u0001\brk>$\u0018mQ1mY\n\f7m\u001b\u0011\u0015\u000fmdXP`@\u0002\u0002A\u0011\u0001\u0005\u0002\u0005\u0006\u0007>\u0001\r!\u0012\u0005\u0006k=\u0001\r!\u0014\u0005\u0006#>\u0001\ra\u0015\u0005\u00065>\u0001\r\u0001\u0018\u0005\u0006Q>\u0001\rA[\u0001\u0016G2LWM\u001c;Rk>$\u0018-T3ue&\u001cg*Y7f)\u0011\t9!a\u0004\u0011\t\u0005%\u00111B\u0007\u0002m%\u0019\u0011Q\u0002\u001c\u0003\u00155+GO]5d\u001d\u0006lW\rC\u0004\u0002\u0012A\u0001\r!a\u0005\u0002\u001fE,x\u000e^1NKR\u0014\u0018n\u0019+bON\u0004R!XA\u000b9rK1!a\u0006g\u0005\ri\u0015\r]\u0001\u0015G2LWM\u001c;SCR,W*\u001a;sS\u000et\u0015-\\3\u0015\t\u0005\u001d\u0011Q\u0004\u0005\b\u0003#\t\u0002\u0019AA\n\u0003Q\u0011XmZ5ti\u0016\u0014\u0018+^8uC6+GO]5dgR!\u00111EA\u001b)\u0011\t)#a\u000b\u0011\u0007\u0011\n9#C\u0002\u0002*\u0015\u0012A!\u00168ji\"9\u0011Q\u0006\nA\u0002\u0005=\u0012AB:f]N|'\u000fE\u00024\u0003cI1!a\r5\u0005\u0019\u0019VM\\:pe\"9\u0011q\u0007\nA\u0002\u0005M\u0011AC7fiJL7\rV1hg\u0006Q\"/Z2pe\u0012\fe\u000eZ$fiRC'o\u001c;uY\u0016$\u0016.\\3NgRQ\u0011QHA\"\u0003'\n9&!\u0019\u0011\u0007\u0011\ny$C\u0002\u0002B\u0015\u00121!\u00138u\u0011\u001d\t)e\u0005a\u0001\u0003\u000f\nqa]3tg&|g\u000e\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti\u0005O\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t\t&a\u0013\u0003\u000fM+7o]5p]\"1\u0011QK\nA\u0002q\u000b\u0001b\u00197jK:$\u0018\n\u001a\u0005\b\u00033\u001a\u0002\u0019AA.\u0003\u00151\u0018\r\\;f!\r!\u0013QL\u0005\u0004\u0003?*#A\u0002#pk\ndW\r\u0003\u0004\u0002dM\u0001\r!L\u0001\u0007i&lW-T:\u0002#9,wo\u0015;sS\u000e$\u0018+^8uC\u001a{'\u000f\u0006\u0004\u0002j\u0005=\u0014\u0011\u000f\t\u0004A\u0005-\u0014bAA75\t92i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019\u0005\b\u0003\u000b\"\u0002\u0019AA$\u0011\u0019\t)\u0006\u0006a\u00019R!\u0011\u0011NA;\u0011\u001d\t9(\u0006a\u0001\u0003s\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002|\u0005\u0015e\u0002BA?\u0003\u0003k!!a \u000b\u0007\u00055C$\u0003\u0003\u0002\u0004\u0006}\u0014A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003\u000f\u000bIIA\u0004SKF,Xm\u001d;\u000b\t\u0005\r\u0015qP\u0001\u0016]\u0016<\b+\u001a:nSN\u001c\u0018N^3Rk>$\u0018MR8s)\u0019\tI'a$\u0002\u0012\"9\u0011Q\t\fA\u0002\u0005\u001d\u0003BBA+-\u0001\u0007A\f\u0006\u0003\u0002j\u0005U\u0005bBA</\u0001\u0007\u0011\u0011P\u0001\f]\u0016<\u0018+^8uC\u001a{'\u000f\u0006\u0004\u0002j\u0005m\u0015Q\u0014\u0005\b\u0003oB\u0002\u0019AA=\u0011\u001d\ty\n\u0007a\u0001\u0003C\u000b!c\u001d;sS\u000e$8+\u001b8dKZ+'o]5p]B\u0019A%a)\n\u0007\u0005\u0015VEA\u0003TQ>\u0014H\u000f")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<Plugin<ClientQuotaCallback>> quotaCallback;

    public static long throttleTimeMs(QuotaViolationException e) {
        return ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<Plugin<ClientQuotaCallback>> quotaCallback() {
        return this.quotaCallback;
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("tokens", QuotaType.CONTROLLER_MUTATION.toString(), "Tracking remaining tokens in the token bucket per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    private MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", QuotaType.CONTROLLER_MUTATION.toString(), "Tracking mutation-rate per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = this.clientRateMetricName(metricTags);
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        metricName = null;
        rate = null;
        sensor.add(this.clientQuotaMetricName(metricTags), (MeasurableStat)new TokenBucket(), this.getQuotaMetricConfig(metricTags));
    }

    @Override
    public int recordAndGetThrottleTimeMs(Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e);
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Quota violated for sensor (" + quotaSensor.name() + "). Delay time: (" + throttleTimeMs + ")");
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<Plugin<ClientQuotaCallback>> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType.CONTROLLER_MUTATION, time, threadNamePrefix, quotaCallback);
    }
}

