/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.internal.Preconditions;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.SimilarityHashPolicy;
import com.dynatrace.hash4j.util.PackedArray;
import java.util.Objects;

abstract class AbstractSimilarityHashPolicy
implements SimilarityHashPolicy {
    protected final int numberOfComponents;
    protected final int signatureSizeInBytes;
    protected final PackedArray.PackedArrayHandler packedArrayHandler;
    protected final PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider;

    protected AbstractSimilarityHashPolicy(int numberOfComponents, int bitsPerComponent, PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        Preconditions.checkArgument(numberOfComponents > 0, "Number of components must be positive!");
        Preconditions.checkArgument(bitsPerComponent >= 1 && bitsPerComponent <= 64, "Bits per component must be in the range [1, 64]!");
        this.numberOfComponents = numberOfComponents;
        this.packedArrayHandler = PackedArray.getHandler(bitsPerComponent);
        this.signatureSizeInBytes = this.packedArrayHandler.numBytes(numberOfComponents);
        this.pseudoRandomGeneratorProvider = Objects.requireNonNull(pseudoRandomGeneratorProvider);
    }

    @Override
    public int getNumberOfComponents() {
        return this.numberOfComponents;
    }

    @Override
    public int getComponentSizeInBits() {
        return this.packedArrayHandler.getBitSize();
    }

    @Override
    public int getNumberOfEqualComponents(byte[] signature1, byte[] signature2) {
        Objects.requireNonNull(signature1);
        Objects.requireNonNull(signature2);
        return this.packedArrayHandler.numEqualComponents(signature1, signature2, this.numberOfComponents);
    }

    @Override
    public int getSignatureSizeInBytes() {
        return this.signatureSizeInBytes;
    }

    @Override
    public long getComponent(byte[] signature, int idx) {
        Objects.requireNonNull(signature);
        Preconditions.checkArgument(signature.length == this.signatureSizeInBytes);
        Preconditions.checkArgument(idx < this.numberOfComponents);
        return this.packedArrayHandler.get(signature, idx);
    }

    @Override
    public double getFractionOfEqualComponents(byte[] signature1, byte[] signature2) {
        return (double)this.getNumberOfEqualComponents(signature1, signature2) / (double)this.numberOfComponents;
    }
}

