/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.runtime.TransformationStage;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;

public class TaskPluginsMetadata {
    private final String connectorClass;
    private final String connectorVersion;
    private final ConnectorType connectorType;
    private final String taskClass;
    private final String taskVersion;
    private final String keyConverterClass;
    private final String keyConverterVersion;
    private final String valueConverterClass;
    private final String valueConverterVersion;
    private final String headerConverterClass;
    private final String headerConverterVersion;
    private final Set<TransformationStage.AliasedPluginInfo> transformations;
    private final Set<TransformationStage.AliasedPluginInfo> predicates;

    public TaskPluginsMetadata(Class<? extends Connector> connectorClass, Task task, Converter keyConverter, Converter valueConverter, HeaderConverter headerConverter, List<TransformationStage.StageInfo> transformationStageInfo, Plugins plugins) {
        assert (connectorClass != null);
        assert (task != null);
        assert (keyConverter != null);
        assert (valueConverter != null);
        assert (headerConverter != null);
        assert (transformationStageInfo != null);
        this.connectorClass = connectorClass.getName();
        this.connectorVersion = plugins.pluginVersion(connectorClass.getName(), connectorClass.getClassLoader(), PluginType.SINK, PluginType.SOURCE);
        this.connectorType = ConnectorType.from(connectorClass);
        this.taskClass = task.getClass().getName();
        this.taskVersion = task.version();
        this.keyConverterClass = keyConverter.getClass().getName();
        this.keyConverterVersion = plugins.pluginVersion(keyConverter.getClass().getName(), keyConverter.getClass().getClassLoader(), PluginType.CONVERTER);
        this.valueConverterClass = valueConverter.getClass().getName();
        this.valueConverterVersion = plugins.pluginVersion(valueConverter.getClass().getName(), valueConverter.getClass().getClassLoader(), PluginType.CONVERTER);
        this.headerConverterClass = headerConverter.getClass().getName();
        this.headerConverterVersion = plugins.pluginVersion(headerConverter.getClass().getName(), headerConverter.getClass().getClassLoader(), PluginType.HEADER_CONVERTER);
        this.transformations = transformationStageInfo.stream().map(TransformationStage.StageInfo::transform).collect(Collectors.toSet());
        this.predicates = transformationStageInfo.stream().map(TransformationStage.StageInfo::predicate).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public String connectorClass() {
        return this.connectorClass;
    }

    public String connectorVersion() {
        return this.connectorVersion;
    }

    public ConnectorType connectorType() {
        return this.connectorType;
    }

    public String taskClass() {
        return this.taskClass;
    }

    public String taskVersion() {
        return this.taskVersion;
    }

    public String keyConverterClass() {
        return this.keyConverterClass;
    }

    public String keyConverterVersion() {
        return this.keyConverterVersion;
    }

    public String valueConverterClass() {
        return this.valueConverterClass;
    }

    public String valueConverterVersion() {
        return this.valueConverterVersion;
    }

    public String headerConverterClass() {
        return this.headerConverterClass;
    }

    public String headerConverterVersion() {
        return this.headerConverterVersion;
    }

    public Set<TransformationStage.AliasedPluginInfo> transformations() {
        return this.transformations;
    }

    public Set<TransformationStage.AliasedPluginInfo> predicates() {
        return this.predicates;
    }
}

