/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.jboss.logging.Logger;

@Deprecated(forRemoval=true)
public class ProcessUtil {
    private static final Logger logger = Logger.getLogger(ProcessUtil.class);

    public static Process launchProcess(ProcessBuilder builder, boolean shouldRedirectIO) throws IOException {
        if (!shouldRedirectIO) {
            return builder.inheritIO().start();
        }
        Process process = builder.redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
        ProcessUtil.streamToSysOutSysErr(process);
        return process;
    }

    public static Process launchProcessStreamStdOut(ProcessBuilder builder, boolean shouldRedirectIO) throws IOException {
        if (!shouldRedirectIO) {
            return builder.inheritIO().start();
        }
        Process process = builder.redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
        ProcessUtil.streamOutputToSysOut(process);
        return process;
    }

    public static void streamToSysOutSysErr(Process process) {
        ProcessUtil.streamOutputToSysOut(process);
        ProcessUtil.streamErrorToSysErr(process);
    }

    public static void streamOutputToSysOut(Process process) {
        InputStream processStdOut = process.getInputStream();
        Thread t = new Thread(new Streamer(processStdOut, System.out));
        t.setName("Process stdout streamer");
        t.setDaemon(true);
        t.start();
    }

    public static void streamErrorToSysErr(Process process) {
        ProcessUtil.streamErrorTo(System.err, process);
    }

    public static void streamErrorTo(PrintStream printStream, Process process) {
        InputStream processStdErr = process.getErrorStream();
        Thread t = new Thread(new Streamer(processStdErr, printStream));
        t.setName("Process stderr streamer");
        t.setDaemon(true);
        t.start();
    }

    private static final class Streamer
    implements Runnable {
        private final InputStream processStream;
        private final PrintStream consumer;

        private Streamer(InputStream processStream, PrintStream consumer) {
            this.processStream = processStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.processStream, StandardCharsets.UTF_8));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.consumer.println(line);
                }
            }
            catch (IOException e) {
                logger.debug((Object)("Ignoring exception that occurred during streaming of " + String.valueOf(this.processStream)), (Throwable)e);
            }
        }
    }
}

