/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.recording;

import io.quarkus.hibernate.orm.runtime.service.InitialInitiatorListProvider;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.cfgxml.internal.ConfigLoader;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.spi.ServiceContributor;

public final class RecordableBootstrap
extends StandardServiceRegistryBuilder {
    private static final String DISABLED_FEATURE_MSG = "This feature was disabled in Quarkus - this method should not have invoked, please report";
    private final Map<String, Object> settings;
    private final List<StandardServiceInitiator<?>> initiators;
    private final List<ProvidedService<?>> providedServices = new ArrayList();
    private final List<Class<? extends Service>> postBuildProvidedServices = new ArrayList<Class<? extends Service>>();
    private boolean autoCloseRegistry = true;
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private final LoadedConfig aggregatedCfgXml;

    public RecordableBootstrap(BootstrapServiceRegistry bootstrapServiceRegistry, InitialInitiatorListProvider initialInitiatorsProvider) {
        this(bootstrapServiceRegistry, new HashMap<String, Object>(), LoadedConfig.baseline(), initialInitiatorsProvider);
    }

    private RecordableBootstrap(BootstrapServiceRegistry bootstrapServiceRegistry, Map<String, Object> properties, LoadedConfig loadedConfigBaseline, InitialInitiatorListProvider initialInitiatorsProvider) {
        super(bootstrapServiceRegistry, properties, new ConfigLoader(bootstrapServiceRegistry), loadedConfigBaseline, null);
        this.settings = properties;
        this.bootstrapServiceRegistry = bootstrapServiceRegistry;
        this.aggregatedCfgXml = loadedConfigBaseline;
        this.initiators = initialInitiatorsProvider.initialInitiatorList();
    }

    public LoadedConfig getAggregatedCfgXml() {
        return this.aggregatedCfgXml;
    }

    public BootstrapServiceRegistry getBootstrapServiceRegistry() {
        return this.bootstrapServiceRegistry;
    }

    public StandardServiceRegistryBuilder loadProperties(String resourceName) {
        throw new UnsupportedOperationException(DISABLED_FEATURE_MSG);
    }

    public StandardServiceRegistryBuilder loadProperties(File file) {
        throw new UnsupportedOperationException(DISABLED_FEATURE_MSG);
    }

    public StandardServiceRegistryBuilder configure() {
        return this.configure("hibernate.cfg.xml");
    }

    public StandardServiceRegistryBuilder configure(String resourceName) {
        throw new UnsupportedOperationException(DISABLED_FEATURE_MSG);
    }

    public StandardServiceRegistryBuilder configure(File configurationFile) {
        throw new UnsupportedOperationException(DISABLED_FEATURE_MSG);
    }

    public StandardServiceRegistryBuilder configure(URL url) {
        throw new UnsupportedOperationException(DISABLED_FEATURE_MSG);
    }

    public StandardServiceRegistryBuilder configure(LoadedConfig loadedConfig) {
        throw new UnsupportedOperationException(DISABLED_FEATURE_MSG);
    }

    public StandardServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.settings.put(settingName, value);
        return this;
    }

    public StandardServiceRegistryBuilder applySettings(Map<String, Object> settings) {
        this.settings.putAll(settings);
        return this;
    }

    public StandardServiceRegistryBuilder clearSettings() {
        this.settings.clear();
        return this;
    }

    public StandardServiceRegistryBuilder addInitiator(StandardServiceInitiator<?> initiator) {
        this.initiators.add(initiator);
        this.postBuildProvidedServices.add(initiator.getServiceInitiated());
        return this;
    }

    public <T extends Service> StandardServiceRegistryBuilder addService(Class<T> serviceRole, T service) {
        this.providedServices.add(new ProvidedService(serviceRole, service));
        return this;
    }

    public StandardServiceRegistryBuilder disableAutoClose() {
        this.autoCloseRegistry = false;
        return this;
    }

    public StandardServiceRegistryBuilder enableAutoClose() {
        this.autoCloseRegistry = true;
        return this;
    }

    public StandardServiceRegistry build() {
        this.applyServiceContributors();
        HashMap<String, Object> settingsCopy = new HashMap<String, Object>();
        settingsCopy.putAll(this.settings);
        settingsCopy.put("hibernate.boot.CfgXmlAccessService.key", this.aggregatedCfgXml);
        return StandardServiceRegistryImpl.create((boolean)this.autoCloseRegistry, (BootstrapServiceRegistry)this.bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
    }

    private void applyServiceContributors() {
        Collection serviceContributors = ((ClassLoaderService)this.bootstrapServiceRegistry.getService(ClassLoaderService.class)).loadJavaServices(ServiceContributor.class);
        for (ServiceContributor serviceContributor : serviceContributors) {
            serviceContributor.contribute((StandardServiceRegistryBuilder)this);
        }
    }

    public List<ProvidedService<?>> getProvidedServices() {
        return this.providedServices;
    }

    @Deprecated
    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public static void destroy(ServiceRegistry serviceRegistry) {
        if (serviceRegistry == null) {
            return;
        }
        ((StandardServiceRegistryImpl)serviceRegistry).destroy();
    }

    public List<Class<? extends Service>> getPostBuildProvidedServices() {
        return this.postBuildProvidedServices;
    }
}

