/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.statement.Response;
import com.webauthn4j.data.jws.JWS;
import com.webauthn4j.data.jws.JWSFactory;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class JWSDeserializer
extends StdDeserializer<JWS<?>> {
    private final JWSFactory jwsFactory;

    public JWSDeserializer(@NotNull ObjectConverter objectConverter) {
        super(JWS.class);
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.jwsFactory = new JWSFactory(objectConverter);
    }

    @NotNull
    public JWS<?> deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) throws IOException {
        byte[] value = p.getBinaryValue();
        String str = new String(value, StandardCharsets.UTF_8);
        try {
            return this.jwsFactory.parse(str, Response.class);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(p, "value is not valid as JWS", (Object)value, JWS.class);
        }
    }
}

