/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionUtil {
    private CollectionUtil() {
    }

    @Nullable
    public static <T> List<T> unmodifiableList(@Nullable List<? extends T> list) {
        return list == null ? null : Collections.unmodifiableList(list);
    }

    @Nullable
    public static <T> Set<T> unmodifiableSet(@Nullable Set<? extends T> set) {
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    @SafeVarargs
    @NotNull
    public static <T> Set<T> unmodifiableSet(T ... items) {
        HashSet<T> set = new HashSet<T>(Arrays.asList(items));
        return Collections.unmodifiableSet(set);
    }

    @Nullable
    public static <K, V> Map<K, V> unmodifiableMap(@Nullable Map<? extends K, ? extends V> map) {
        return map == null ? null : Collections.unmodifiableMap(map);
    }
}

