/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.common.util.Time;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OfflineUserSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.session.ClientSessionLoader;
import org.keycloak.models.jpa.session.PersistentClientSessionEntity;
import org.keycloak.models.jpa.session.PersistentUserSessionEntity;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;
import org.keycloak.models.session.PersistentClientSessionModel;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.utils.SessionExpirationUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.utils.StreamsUtil;

public class JpaUserSessionPersisterProvider
implements UserSessionPersisterProvider {
    private static final Logger logger = Logger.getLogger(JpaUserSessionPersisterProvider.class);
    private final KeycloakSession session;
    private final EntityManager em;

    public JpaUserSessionPersisterProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void createUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        PersistentUserSessionEntity entity = new PersistentUserSessionEntity();
        entity.setUserSessionId(model.getUserSessionId());
        entity.setCreatedOn(model.getStarted());
        entity.setRealmId(adapter.getRealm().getId());
        entity.setUserId(adapter.getUser().getId());
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        entity.setOffline(offlineStr);
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        this.em.persist((Object)entity);
    }

    public void createClientSession(AuthenticatedClientSessionModel clientSession, boolean offline) {
        String externalClientId;
        String clientStorageProvider;
        String clientId;
        PersistentAuthenticatedClientSessionAdapter adapter = new PersistentAuthenticatedClientSessionAdapter(this.session, clientSession);
        PersistentClientSessionModel model = adapter.getUpdatedModel();
        String userSessionId = clientSession.getUserSession().getId();
        StorageId clientStorageId = new StorageId(clientSession.getClient().getId());
        if (clientStorageId.isLocal()) {
            clientId = clientStorageId.getId();
            clientStorageProvider = "local";
            externalClientId = "local";
        } else {
            clientId = "external";
            clientStorageProvider = clientStorageId.getProviderId();
            externalClientId = clientStorageId.getExternalId();
        }
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        boolean exists = false;
        PersistentClientSessionEntity entity = (PersistentClientSessionEntity)this.em.find(PersistentClientSessionEntity.class, (Object)new PersistentClientSessionEntity.Key(userSessionId, clientId, clientStorageProvider, externalClientId, offlineStr));
        if (entity != null) {
            exists = true;
        } else {
            entity = new PersistentClientSessionEntity();
            entity.setUserSessionId(userSessionId);
            entity.setClientId(clientId);
            entity.setClientStorageProvider(clientStorageProvider);
            entity.setExternalClientId(externalClientId);
            entity.setOffline(offlineStr);
        }
        entity.setTimestamp(clientSession.getTimestamp());
        entity.setData(model.getData());
        if (!exists) {
            this.em.persist((Object)entity);
        }
    }

    public void removeUserSession(String userSessionId, boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        this.em.createNamedQuery("deleteClientSessionsByUserSession").setParameter("userSessionId", (Object)userSessionId).setParameter("offline", (Object)offlineStr).executeUpdate();
        this.removeUserSessionFromDatabase(userSessionId, offlineStr);
    }

    public void removeClientSession(String userSessionId, String clientUUID, boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        StorageId clientStorageId = new StorageId(clientUUID);
        String clientId = "external";
        String clientStorageProvider = "local";
        String externalId = "local";
        if (clientStorageId.isLocal()) {
            clientId = clientUUID;
        } else {
            clientStorageProvider = clientStorageId.getProviderId();
            externalId = clientStorageId.getExternalId();
        }
        PersistentClientSessionEntity sessionEntity = (PersistentClientSessionEntity)this.em.find(PersistentClientSessionEntity.class, (Object)new PersistentClientSessionEntity.Key(userSessionId, clientId, clientStorageProvider, externalId, offlineStr), LockModeType.PESSIMISTIC_WRITE);
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            if (offline && this.hasNoClientSessions(userSessionId, offlineStr)) {
                this.removeUserSessionFromDatabase(userSessionId, offlineStr);
            }
        }
    }

    private void removeUserSessionFromDatabase(String userSessionId, String offlineStr) {
        PersistentUserSessionEntity userSessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(userSessionId, offlineStr), LockModeType.PESSIMISTIC_WRITE);
        if (userSessionEntity != null) {
            this.em.remove((Object)userSessionEntity);
        }
    }

    private boolean hasNoClientSessions(String userSessionId, String offline) {
        TypedQuery query = this.em.createNamedQuery("findClientSessionsByUserSession", PersistentClientSessionEntity.class);
        query.setParameter("userSessionId", (Object)userSessionId);
        query.setParameter("offline", (Object)offline);
        query.setMaxResults(1);
        return query.getSingleResultOrNull() == null;
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(client.getId());
    }

    private void onClientRemoved(String clientUUID) {
        logger.debugf("Client sessions removed for client %s", (Object)clientUUID);
        StorageId clientStorageId = new StorageId(clientUUID);
        if (clientStorageId.isLocal()) {
            this.em.createNamedQuery("deleteClientSessionsByClient").setParameter("clientId", (Object)clientUUID).executeUpdate();
        } else {
            this.em.createNamedQuery("deleteClientSessionsByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        String userId = user.getId();
        this.em.createNamedQuery("deleteClientSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
        this.em.createNamedQuery("deleteUserSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
    }

    public void updateLastSessionRefreshes(RealmModel realm, int lastSessionRefresh, Collection<String> userSessionIds, boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        int us = this.em.createNamedQuery("updateUserSessionLastSessionRefresh").setParameter("lastSessionRefresh", (Object)lastSessionRefresh).setParameter("realmId", (Object)realm.getId()).setParameter("offline", (Object)offlineStr).setParameter("userSessionIds", userSessionIds).executeUpdate();
        logger.debugf("Updated lastSessionRefresh of %d user sessions in realm '%s'", us, (Object)realm.getName());
    }

    public void removeExpired(RealmModel realm) {
        int expiredOffline = JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, true) - 180;
        this.expire(realm, expiredOffline, true);
        if (MultiSiteUtils.isPersistentSessionsEnabled()) {
            int expired = JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, false) - 180;
            this.expire(realm, expired, false);
        }
    }

    private static int calculateOldestSessionTime(RealmModel realm, boolean offline) {
        return Time.currentTime() - (int)TimeUnit.MILLISECONDS.toSeconds(SessionExpirationUtils.calculateUserSessionIdleTimestamp((boolean)offline, (boolean)realm.isRememberMe(), (long)0L, (RealmModel)realm));
    }

    private void expire(RealmModel realm, int expired, boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        logger.tracef("Trigger removing expired user sessions for realm '%s'", (Object)realm.getName());
        int cs = this.em.createNamedQuery("deleteExpiredClientSessions").setParameter("realmId", (Object)realm.getId()).setParameter("lastSessionRefresh", (Object)expired).setParameter("offline", (Object)offlineStr).executeUpdate();
        int us = this.em.createNamedQuery("deleteExpiredUserSessions").setParameter("realmId", (Object)realm.getId()).setParameter("lastSessionRefresh", (Object)expired).setParameter("offline", (Object)offlineStr).executeUpdate();
        logger.debugf("Removed %d expired user sessions and %d expired client sessions in realm '%s'", us, cs, (Object)realm.getName());
    }

    public Map<String, Long> getUserSessionsCountsByClients(RealmModel realm, boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        TypedQuery query = this.em.createNamedQuery("findClientSessionsClientIds", Object[].class);
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("lastSessionRefresh", (Object)JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, offline));
        return StreamsUtil.closing((Stream)query.getResultStream()).collect(Collectors.toMap(row -> {
            String clientId = row[0].toString();
            if (clientId.equals("external")) {
                String externalClientId = row[1].toString();
                String clientStorageProvider = row[2].toString();
                clientId = new StorageId(clientStorageProvider, externalClientId).getId();
            }
            return clientId;
        }, row -> (Long)row[3]));
    }

    public UserSessionModel loadUserSession(RealmModel realm, String userSessionId, boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        TypedQuery userSessionQuery = this.em.createNamedQuery("findUserSession", PersistentUserSessionEntity.class);
        userSessionQuery.setParameter("realmId", (Object)realm.getId());
        userSessionQuery.setParameter("offline", (Object)offlineStr);
        userSessionQuery.setParameter("userSessionId", (Object)userSessionId);
        userSessionQuery.setParameter("lastSessionRefresh", (Object)JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, offline));
        userSessionQuery.setMaxResults(1);
        return this.handleSingleQuery((TypedQuery<PersistentUserSessionEntity>)userSessionQuery, offlineStr);
    }

    public UserSessionModel loadUserSessionsStreamByBrokerSessionId(RealmModel realm, String brokerSessionId, boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        TypedQuery userSessionQuery = this.em.createNamedQuery("findUserSessionsByBrokerSessionId", PersistentUserSessionEntity.class);
        userSessionQuery.setParameter("realmId", (Object)realm.getId());
        userSessionQuery.setParameter("brokerSessionId", (Object)brokerSessionId);
        userSessionQuery.setParameter("offline", (Object)offlineStr);
        userSessionQuery.setParameter("lastSessionRefresh", (Object)JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, offline));
        userSessionQuery.setMaxResults(1);
        return this.handleSingleQuery((TypedQuery<PersistentUserSessionEntity>)userSessionQuery, offlineStr);
    }

    private UserSessionModel handleSingleQuery(TypedQuery<PersistentUserSessionEntity> query, String offlineStr) {
        PersistentUserSessionEntity entity = (PersistentUserSessionEntity)query.getSingleResultOrNull();
        if (entity == null) {
            return null;
        }
        PersistentUserSessionAdapter userSession = this.toAdapter(entity);
        if (userSession == null) {
            return null;
        }
        ClientSessionLoader initializer = new ClientSessionLoader(() -> this.fetchClientSessions(userSession, offlineStr));
        userSession.setClientSessionsLoader((Consumer)initializer);
        return userSession;
    }

    public Stream<UserSessionModel> loadUserSessionsStream(RealmModel realm, ClientModel client, boolean offline, Integer firstResult, Integer maxResults) {
        TypedQuery query;
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        StorageId clientStorageId = new StorageId(client.getId());
        if (clientStorageId.isLocal()) {
            query = PaginationUtils.paginateQuery((TypedQuery)this.em.createNamedQuery("findUserSessionsByClientId", PersistentUserSessionEntity.class), (Integer)firstResult, (Integer)maxResults);
            query.setParameter("clientId", (Object)client.getId());
            query.setParameter("lastSessionRefresh", (Object)JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, offline));
        } else {
            query = PaginationUtils.paginateQuery((TypedQuery)this.em.createNamedQuery("findUserSessionsByExternalClientId", PersistentUserSessionEntity.class), (Integer)firstResult, (Integer)maxResults);
            query.setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId());
            query.setParameter("externalClientId", (Object)clientStorageId.getExternalId());
            query.setParameter("lastSessionRefresh", (Object)JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, offline));
        }
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("realmId", (Object)realm.getId());
        return this.loadExactUserSessionsWithClientSessions((TypedQuery<PersistentUserSessionEntity>)query, offlineStr);
    }

    public Stream<UserSessionModel> loadUserSessionsStream(RealmModel realm, UserModel user, boolean offline, Integer firstResult, Integer maxResults) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        TypedQuery query = PaginationUtils.paginateQuery((TypedQuery)this.em.createNamedQuery("findUserSessionsByUserId", PersistentUserSessionEntity.class), (Integer)firstResult, (Integer)maxResults);
        query.setParameter("offline", (Object)offlineStr);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("userId", (Object)user.getId());
        query.setParameter("lastSessionRefresh", (Object)JpaUserSessionPersisterProvider.calculateOldestSessionTime(realm, offline));
        return this.loadExactUserSessionsWithClientSessions((TypedQuery<PersistentUserSessionEntity>)query, offlineStr);
    }

    public Stream<UserSessionModel> loadUserSessionsStream(Integer firstResult, Integer maxResults, boolean offline, String lastUserSessionId) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        TypedQuery query = PaginationUtils.paginateQuery((TypedQuery)this.em.createNamedQuery("findUserSessionsOrderedById", PersistentUserSessionEntity.class).setParameter("offline", (Object)offlineStr).setParameter("lastSessionId", (Object)lastUserSessionId), (Integer)firstResult, (Integer)maxResults);
        return this.loadUserSessionsWithClientSessions((TypedQuery<PersistentUserSessionEntity>)query, offlineStr);
    }

    public AuthenticatedClientSessionModel loadClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession, boolean offline) {
        TypedQuery query;
        StorageId clientStorageId = new StorageId(client.getId());
        if (clientStorageId.isLocal()) {
            query = this.em.createNamedQuery("findClientSessionsByUserSessionAndClient", PersistentClientSessionEntity.class);
            query.setParameter("clientId", (Object)client.getId());
        } else {
            query = this.em.createNamedQuery("findClientSessionsByUserSessionAndExternalClient", PersistentClientSessionEntity.class);
            query.setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId());
            query.setParameter("externalClientId", (Object)clientStorageId.getExternalId());
        }
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        query.setParameter("userSessionId", (Object)userSession.getId());
        query.setParameter("offline", (Object)offlineStr);
        query.setMaxResults(1);
        return StreamsUtil.closing((Stream)query.getResultStream()).map(entity -> this.toAdapter(realm, client, userSession, (PersistentClientSessionEntity)entity)).findFirst().orElse(null);
    }

    private Stream<UserSessionModel> loadExactUserSessionsWithClientSessions(TypedQuery<PersistentUserSessionEntity> query, String offlineStr) {
        return StreamsUtil.closing(StreamsUtil.chunkedStream(StreamsUtil.closing((Stream)query.getResultStream()).map(this::toAdapter).filter(Objects::nonNull), (int)100).flatMap(batchedUserSessions -> {
            HashSet<String> removedClientUUIDs = new HashSet<String>();
            Map<String, OfflineUserSessionModel> sessionsById = batchedUserSessions.stream().collect(Collectors.toMap(UserSessionModel::getId, Function.identity()));
            Set<String> userSessionIds = sessionsById.keySet();
            TypedQuery queryClientSessions = this.em.createNamedQuery("findClientSessionsOrderedByIdExact", PersistentClientSessionEntity.class);
            queryClientSessions.setParameter("offline", (Object)offlineStr);
            queryClientSessions.setParameter("userSessionIds", userSessionIds);
            this.processClientSessions(sessionsById, removedClientUUIDs, (TypedQuery<PersistentClientSessionEntity>)queryClientSessions);
            removedClientUUIDs.forEach(this::onClientRemoved);
            logger.tracef("Loaded %d batch of user sessions (offline=%s, sessionIds=%s)", batchedUserSessions.size(), (Object)offlineStr, sessionsById.keySet());
            return batchedUserSessions.stream();
        }).map(UserSessionModel.class::cast));
    }

    private Stream<UserSessionModel> loadUserSessionsWithClientSessions(TypedQuery<PersistentUserSessionEntity> query, String offlineStr) {
        List userSessionAdapters = StreamsUtil.closing(query.getResultStream().map(this::toAdapter).filter(Objects::nonNull)).toList();
        if (userSessionAdapters.isEmpty()) {
            return Stream.of(new UserSessionModel[0]);
        }
        Map<String, OfflineUserSessionModel> sessionsById = userSessionAdapters.stream().collect(Collectors.toMap(UserSessionModel::getId, Function.identity()));
        HashSet<String> removedClientUUIDs = new HashSet<String>();
        String fromUserSessionId = ((PersistentUserSessionAdapter)userSessionAdapters.get(0)).getId();
        String toUserSessionId = ((PersistentUserSessionAdapter)userSessionAdapters.get(userSessionAdapters.size() - 1)).getId();
        TypedQuery queryClientSessions = this.em.createNamedQuery("findClientSessionsOrderedByIdInterval", PersistentClientSessionEntity.class);
        queryClientSessions.setParameter("offline", (Object)offlineStr);
        queryClientSessions.setParameter("fromSessionId", (Object)fromUserSessionId);
        queryClientSessions.setParameter("toSessionId", (Object)toUserSessionId);
        this.processClientSessions(sessionsById, removedClientUUIDs, (TypedQuery<PersistentClientSessionEntity>)queryClientSessions);
        removedClientUUIDs.forEach(this::onClientRemoved);
        logger.tracef("Loaded %d user sessions (offline=%s, sessionIds=%s)", userSessionAdapters.size(), (Object)offlineStr, sessionsById.keySet());
        return userSessionAdapters.stream().map(UserSessionModel.class::cast);
    }

    private void processClientSessions(Map<String, OfflineUserSessionModel> sessionsById, Set<String> removedClientUUIDs, TypedQuery<PersistentClientSessionEntity> queryClientSessions) {
        StreamsUtil.closing((Stream)queryClientSessions.getResultStream()).forEach(clientSession -> {
            boolean added;
            OfflineUserSessionModel userSession = (OfflineUserSessionModel)sessionsById.get(clientSession.getUserSessionId());
            if (userSession != null && !(added = this.addClientSessionToAuthenticatedClientSessionsIfPresent((UserSessionModel)userSession, (PersistentClientSessionEntity)clientSession))) {
                removedClientUUIDs.add(clientSession.getClientId());
            }
        });
    }

    private boolean addClientSessionToAuthenticatedClientSessionsIfPresent(UserSessionModel userSession, PersistentClientSessionEntity clientSessionEntity) {
        PersistentAuthenticatedClientSessionAdapter clientSessAdapter = this.toAdapter(userSession.getRealm(), null, userSession, clientSessionEntity);
        if (clientSessAdapter.getClient() == null) {
            logger.debugf("Not adding client session %s / %s since client is null", (Object)userSession, (Object)clientSessAdapter);
            return false;
        }
        logger.tracef("Adding client session %s / %s", (Object)userSession, (Object)clientSessAdapter);
        userSession.getAuthenticatedClientSessions().put(JpaUserSessionPersisterProvider.getClientId(clientSessionEntity), clientSessAdapter);
        return true;
    }

    private PersistentUserSessionAdapter toAdapter(PersistentUserSessionEntity entity) {
        RealmModel realm = this.session.realms().getRealm(entity.getRealmId());
        if (realm == null) {
            return null;
        }
        return this.toAdapter(realm, entity);
    }

    private PersistentUserSessionAdapter toAdapter(RealmModel realm, final PersistentUserSessionEntity entity) {
        PersistentUserSessionModel model = new PersistentUserSessionModel(){

            public String getUserSessionId() {
                return entity.getUserSessionId();
            }

            public void setUserSessionId(String userSessionId) {
                entity.setUserSessionId(userSessionId);
            }

            public int getStarted() {
                return entity.getCreatedOn();
            }

            public void setStarted(int started) {
                entity.setCreatedOn(started);
            }

            public int getLastSessionRefresh() {
                return entity.getLastSessionRefresh();
            }

            public void setLastSessionRefresh(int lastSessionRefresh) {
                entity.setLastSessionRefresh(lastSessionRefresh);
            }

            public boolean isOffline() {
                return JpaUserSessionPersisterProvider.offlineFromString(entity.getOffline());
            }

            public void setOffline(boolean offline) {
                entity.setOffline(JpaUserSessionPersisterProvider.offlineToString(offline));
            }

            public String getData() {
                return entity.getData();
            }

            public void setData(String data) {
                entity.setData(data);
            }

            public void setRealmId(String realmId) {
                entity.setRealmId(realmId);
            }

            public void setUserId(String userId) {
                entity.setUserId(userId);
            }

            public void setBrokerSessionId(String brokerSessionId) {
                entity.setBrokerSessionId(brokerSessionId);
            }
        };
        HashMap clientSessions = new HashMap();
        return new PersistentUserSessionAdapter(this.session, model, realm, entity.getUserId(), clientSessions);
    }

    private PersistentAuthenticatedClientSessionAdapter toAdapter(RealmModel realm, ClientModel client, UserSessionModel userSession, final PersistentClientSessionEntity entity) {
        if (client == null && (client = realm.getClientById(JpaUserSessionPersisterProvider.getClientId(entity))) == null) {
            logger.debugf("Client not found for clientId %s clientStorageProvider %s externalClientId %s", (Object)entity.getClientId(), (Object)entity.getClientStorageProvider(), (Object)entity.getExternalClientId());
        }
        PersistentClientSessionModel model = new PersistentClientSessionModel(){

            public String getUserSessionId() {
                return entity.getUserSessionId();
            }

            public void setUserSessionId(String userSessionId) {
                entity.setUserSessionId(userSessionId);
            }

            public String getClientId() {
                return JpaUserSessionPersisterProvider.getClientId(entity);
            }

            public void setClientId(String clientId) {
                throw new IllegalStateException("forbidden");
            }

            public int getTimestamp() {
                return entity.getTimestamp();
            }

            public void setTimestamp(int timestamp) {
                entity.setTimestamp(timestamp);
            }

            public String getData() {
                return entity.getData();
            }

            public void setData(String data) {
                entity.setData(data);
            }
        };
        return new PersistentAuthenticatedClientSessionAdapter(this.session, model, realm, client, userSession);
    }

    public int getUserSessionsCount(boolean offline) {
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        Query query = this.em.createNamedQuery("findUserSessionsCount");
        query.setParameter("offline", (Object)offlineStr);
        Number n = (Number)query.getSingleResult();
        return n.intValue();
    }

    public int getUserSessionsCount(RealmModel realm, ClientModel clientModel, boolean offline) {
        Query query;
        String offlineStr = JpaUserSessionPersisterProvider.offlineToString(offline);
        StorageId clientStorageId = new StorageId(clientModel.getId());
        if (clientStorageId.isLocal()) {
            query = this.em.createNamedQuery("findClientSessionsCountByClient");
            query.setParameter("clientId", (Object)clientModel.getId());
        } else {
            query = this.em.createNamedQuery("findClientSessionsCountByExternalClient");
            query.setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId());
            query.setParameter("externalClientId", (Object)clientStorageId.getExternalId());
        }
        query.setParameter("offline", (Object)offlineStr);
        Number n = (Number)query.getSingleResult();
        return n.intValue();
    }

    public void removeUserSessions(RealmModel realm, boolean offline) {
        this.em.createNamedQuery("deleteClientSessionsByRealmSessionType").setParameter("realmId", (Object)realm.getId()).setParameter("offline", (Object)JpaUserSessionPersisterProvider.offlineToString(offline)).executeUpdate();
        this.em.createNamedQuery("deleteUserSessionsByRealmSessionType").setParameter("realmId", (Object)realm.getId()).setParameter("offline", (Object)JpaUserSessionPersisterProvider.offlineToString(offline)).executeUpdate();
    }

    public void removeUserSessions(RealmModel realm) {
        this.em.createNamedQuery("deleteClientSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("deleteUserSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void close() {
    }

    private static String offlineToString(boolean offline) {
        return offline ? "1" : "0";
    }

    private static boolean offlineFromString(String offlineStr) {
        return "1".equals(offlineStr);
    }

    private static boolean isExternalClient(PersistentClientSessionEntity entity) {
        return !entity.getExternalClientId().equals("local");
    }

    private static String getExternalClientId(PersistentClientSessionEntity entity) {
        return new StorageId(entity.getClientStorageProvider(), entity.getExternalClientId()).getId();
    }

    private static String getClientId(PersistentClientSessionEntity entity) {
        return JpaUserSessionPersisterProvider.isExternalClient(entity) ? JpaUserSessionPersisterProvider.getExternalClientId(entity) : entity.getClientId();
    }

    private Stream<PersistentAuthenticatedClientSessionAdapter> fetchClientSessions(PersistentUserSessionAdapter userSession, String offlineStr) {
        TypedQuery clientSessionQuery = this.em.createNamedQuery("findClientSessionsByUserSession", PersistentClientSessionEntity.class);
        clientSessionQuery.setParameter("userSessionId", (Object)userSession.getId());
        clientSessionQuery.setParameter("offline", (Object)offlineStr);
        return StreamsUtil.closing(clientSessionQuery.getResultStream().map(entity -> this.toAdapter(userSession.getRealm(), null, (UserSessionModel)userSession, (PersistentClientSessionEntity)entity)).filter(JpaUserSessionPersisterProvider::hasClient));
    }

    private static boolean hasClient(PersistentAuthenticatedClientSessionAdapter clientSession) {
        return clientSession.getClient() != null;
    }
}

