/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authorization.admin.AuthorizationService;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.client.clienttype.ClientTypeException;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.AdminClientRegisterContext;
import org.keycloak.services.clientpolicy.context.AdminClientRegisteredContext;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.ClientResource;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.utils.SearchQueryUtils;
import org.keycloak.utils.StreamsUtil;
import org.keycloak.validation.ValidationUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class ClientsResource {
    protected static final Logger logger = Logger.getLogger(ClientsResource.class);
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    protected final KeycloakSession session;

    public ClientsResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Clients")
    @Operation(summary="Get clients belonging to the realm.", description="If a client can\u2019t be retrieved from the storage due to a problem with the underlying storage, it is silently removed from the returned list. This ensures that concurrent modifications to the list don\u2019t prevent callers from retrieving this list.")
    public Stream<ClientRepresentation> getClients(@Parameter(description="filter by clientId") @QueryParam(value="clientId") String clientId, @Parameter(description="filter clients that cannot be viewed in full by admin") @QueryParam(value="viewableOnly") @DefaultValue(value="false") boolean viewableOnly, @Parameter(description="whether this is a search query or a getClientById query") @QueryParam(value="search") @DefaultValue(value="false") boolean search, @QueryParam(value="q") String searchQuery, @Parameter(description="the first result") @QueryParam(value="first") Integer firstResult, @Parameter(description="the max results to return") @QueryParam(value="max") Integer maxResults) {
        this.auth.clients().requireList();
        boolean canView = AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) || this.auth.clients().canView();
        Stream<ClientModel> clientModels = Stream.empty();
        if (searchQuery != null) {
            Map<String, String> attributes = SearchQueryUtils.getFields(searchQuery);
            clientModels = canView ? this.realm.searchClientByAttributes(attributes, firstResult, maxResults) : this.realm.searchClientByAttributes(attributes, Integer.valueOf(-1), Integer.valueOf(-1));
        } else if (clientId == null || clientId.trim().equals("")) {
            clientModels = canView ? this.realm.getClientsStream(firstResult, maxResults) : this.realm.getClientsStream();
        } else if (search) {
            clientModels = canView ? this.realm.searchClientByClientIdStream(clientId, firstResult, maxResults) : this.realm.searchClientByClientIdStream(clientId, Integer.valueOf(-1), Integer.valueOf(-1));
        } else {
            ClientModel client = this.realm.getClientByClientId(clientId);
            if (client != null) {
                clientModels = AdminPermissionsSchema.SCHEMA.isAdminPermissionsEnabled(this.realm) ? Stream.of(client).filter(this.auth.clients()::canView) : Stream.of(client);
            }
        }
        Stream s = ModelToRepresentation.filterValidRepresentations((Stream)clientModels, c -> {
            ClientRepresentation representation = null;
            if (canView || this.auth.clients().canView((ClientModel)c)) {
                representation = ModelToRepresentation.toRepresentation((ClientModel)c, (KeycloakSession)this.session);
                representation.setAccess(this.auth.clients().getAccess((ClientModel)c));
            } else if (!viewableOnly && this.auth.clients().canView((ClientModel)c)) {
                representation = new ClientRepresentation();
                representation.setId(c.getId());
                representation.setClientId(c.getClientId());
                representation.setDescription(c.getDescription());
            }
            return representation;
        });
        if (!canView) {
            s = StreamsUtil.paginatedStream((Stream)s, (Integer)firstResult, (Integer)maxResults);
        }
        return s;
    }

    private AuthorizationService getAuthorizationService(ClientModel clientModel) {
        return new AuthorizationService(this.session, clientModel, this.auth, this.adminEvent);
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Clients")
    @Operation(summary="Create a new client Client\u2019s client_id must be unique!")
    @APIResponses(value={@APIResponse(responseCode="201", description="Created"), @APIResponse(responseCode="409", description="Conflict")})
    public Response createClient(ClientRepresentation rep) {
        this.auth.clients().requireManage();
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AdminClientRegisterContext(rep, this.auth.adminAuth()));
            ClientModel clientModel = ClientManager.createClient(this.session, this.realm, rep);
            if (Boolean.TRUE.equals(rep.isServiceAccountsEnabled())) {
                new ClientManager(new RealmManager(this.session)).enableServiceAccount(clientModel);
            }
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), clientModel.getId()).representation(rep).success();
            if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION) && Boolean.TRUE.equals(rep.getAuthorizationServicesEnabled())) {
                AuthorizationService authorizationService = this.getAuthorizationService(clientModel);
                authorizationService.enable(true);
                ResourceServerRepresentation authorizationSettings = rep.getAuthorizationSettings();
                if (authorizationSettings != null) {
                    authorizationService.getResourceServerService().importSettings(authorizationSettings);
                }
            }
            ValidationUtil.validateClient((KeycloakSession)this.session, (ClientModel)clientModel, (boolean)true, r -> {
                this.session.getTransactionManager().setRollbackOnly();
                throw new ErrorResponseException("invalid_input", r.getAllLocalizedErrorsAsString(AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale())), Response.Status.BAD_REQUEST);
            });
            this.session.getContext().setClient(clientModel);
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new AdminClientRegisteredContext(clientModel, this.auth.adminAuth()));
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(clientModel.getId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Client " + rep.getClientId() + " already exists");
        }
        catch (ClientPolicyException cpe) {
            throw new ErrorResponseException(cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        catch (ModelValidationException e) {
            throw new ErrorResponseException("validation error", e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (ClientTypeException cte) {
            throw ErrorResponse.error(cte.getMessage(), cte.getParameters(), Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="{client-uuid}")
    public ClientResource getClient(@PathParam(value="client-uuid") @Parameter(description="id of client (not client-id!)") String id) {
        ClientModel clientModel = this.realm.getClientById(id);
        if (clientModel == null) {
            if (this.auth.clients().canList()) {
                throw new NotFoundException("Could not find client");
            }
            throw new ForbiddenException();
        }
        this.session.getContext().setClient(clientModel);
        return new ClientResource(this.realm, this.auth, clientModel, this.session, this.adminEvent);
    }
}

