/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.vault.DefaultVaultCharSecret;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.DefaultVaultStringSecret;
import org.keycloak.vault.VaultCharSecret;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultRawSecret;
import org.keycloak.vault.VaultStringSecret;
import org.keycloak.vault.VaultTranscriber;

public class DefaultVaultTranscriber
implements VaultTranscriber {
    private static final Pattern pattern = Pattern.compile("^\\$\\{vault\\.(.+?)}$");
    private final VaultProvider provider;

    public DefaultVaultTranscriber(VaultProvider provider) {
        this.provider = provider == null ? new VaultProvider(){

            public VaultRawSecret obtainSecret(String vaultSecretId) {
                return DefaultVaultRawSecret.forBuffer(null);
            }

            public void close() {
            }
        } : provider;
    }

    public VaultRawSecret getRawSecret(String value) {
        String entryId = this.getVaultEntryKey(value);
        if (entryId != null) {
            return this.provider.obtainSecret(entryId);
        }
        ByteBuffer buffer = value != null ? ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8)) : null;
        return DefaultVaultRawSecret.forBuffer(Optional.ofNullable(buffer));
    }

    public VaultCharSecret getCharSecret(String value) {
        try (VaultRawSecret rawSecret = this.getRawSecret(value);){
            if (!rawSecret.get().isPresent()) {
                VaultCharSecret vaultCharSecret = DefaultVaultCharSecret.forBuffer(Optional.empty());
                return vaultCharSecret;
            }
            ByteBuffer rawSecretBuffer = (ByteBuffer)rawSecret.get().get();
            CharBuffer charSecretBuffer = StandardCharsets.UTF_8.decode(rawSecretBuffer);
            VaultCharSecret vaultCharSecret = DefaultVaultCharSecret.forBuffer(Optional.of(charSecretBuffer));
            return vaultCharSecret;
        }
    }

    public VaultStringSecret getStringSecret(String value) {
        try (VaultRawSecret rawSecret = this.getRawSecret(value);){
            if (!rawSecret.get().isPresent()) {
                VaultStringSecret vaultStringSecret = DefaultVaultStringSecret.forString(Optional.empty());
                return vaultStringSecret;
            }
            ByteBuffer rawSecretBuffer = (ByteBuffer)rawSecret.get().get();
            VaultStringSecret vaultStringSecret = DefaultVaultStringSecret.forString(Optional.of(StandardCharsets.UTF_8.decode(rawSecretBuffer).toString()));
            return vaultStringSecret;
        }
    }

    private String getVaultEntryKey(String value) {
        Matcher matcher;
        if (value != null && (matcher = pattern.matcher(value)).matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

