/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction.entry;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.VersionedValueImpl;
import org.infinispan.client.hotrod.impl.transaction.entry.ControlByte;
import org.infinispan.client.hotrod.impl.transaction.entry.Modification;
import org.infinispan.commons.util.Util;

public class TransactionEntry<K, V> {
    private final K key;
    private final long version;
    private final byte readControl;
    private V value;
    private long created = -1L;
    private long lastUsed = -1L;
    private long lifespan = -1L;
    private TimeUnit lifespanTimeUnit;
    private long maxIdle = -1L;
    private TimeUnit maxIdleTimeUnit;
    private boolean modified;

    private TransactionEntry(K key, long version, byte readControl) {
        this.key = key;
        this.version = version;
        this.readControl = readControl;
        this.modified = false;
    }

    public static <K, V> TransactionEntry<K, V> nonExistingEntry(K key) {
        return new TransactionEntry<K, V>(key, 0L, ControlByte.NON_EXISTING.bit());
    }

    public static <K, V> TransactionEntry<K, V> notReadEntry(K key) {
        return new TransactionEntry<K, V>(key, 0L, ControlByte.NOT_READ.bit());
    }

    public static <K, V> TransactionEntry<K, V> read(K key, MetadataValue<V> value) {
        TransactionEntry<K, V> entry = new TransactionEntry<K, V>(key, value.getVersion(), 0);
        entry.init(value);
        return entry;
    }

    public long getVersion() {
        return this.version;
    }

    public V getValue() {
        return this.value;
    }

    public VersionedValue<V> toVersionValue() {
        return this.isNonExists() ? null : new VersionedValueImpl<V>(this.version, this.value);
    }

    public MetadataValue<V> toMetadataValue() {
        return this.isNonExists() ? null : new MetadataValueImpl<V>(this.created, this.getLifespan(), this.lastUsed, this.getMaxIdle(), this.version, this.value);
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isNonExists() {
        return this.value == null;
    }

    public boolean exists() {
        return this.value != null;
    }

    public void set(V value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        this.value = value;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
        this.modified = true;
    }

    public void remove() {
        this.value = null;
        this.modified = true;
    }

    public Modification toModification(Function<K, byte[]> keyMarshaller, Function<V, byte[]> valueMarshaller) {
        if (this.value == null) {
            return new Modification(keyMarshaller.apply(this.key), null, this.version, 0L, 0L, null, null, ControlByte.REMOVE_OP.set(this.readControl));
        }
        return new Modification(keyMarshaller.apply(this.key), valueMarshaller.apply(this.value), this.version, this.lifespan, this.maxIdle, this.lifespanTimeUnit, this.maxIdleTimeUnit, this.readControl);
    }

    public String toString() {
        return "TransactionEntry{key=" + Util.toStr(this.key) + ", version=" + this.version + ", readControl=" + ControlByte.prettyPrint(this.readControl) + ", value=" + Util.toStr(this.value) + ", created=" + this.created + ", lifespan=" + this.lifespan + ", lifespanTimeUnit=" + String.valueOf((Object)this.lifespanTimeUnit) + ", maxIdle=" + this.maxIdle + ", maxIdleTimeUnit=" + String.valueOf((Object)this.maxIdleTimeUnit) + ", modified=" + this.modified + "}";
    }

    private int getLifespan() {
        return this.lifespan < 0L ? -1 : (int)this.lifespanTimeUnit.toSeconds(this.lifespan);
    }

    private int getMaxIdle() {
        return this.maxIdle < 0L ? -1 : (int)this.maxIdleTimeUnit.toSeconds(this.maxIdle);
    }

    private void init(MetadataValue<V> metadataValue) {
        this.value = metadataValue.getValue();
        this.created = metadataValue.getCreated();
        this.lastUsed = metadataValue.getLastUsed();
        this.lifespan = metadataValue.getLifespan();
        this.lifespanTimeUnit = TimeUnit.SECONDS;
        this.maxIdle = metadataValue.getMaxIdle();
        this.maxIdleTimeUnit = TimeUnit.SECONDS;
    }
}

