/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Map;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.DefaultAuthenticationFlows;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo1_7_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("1.7.0");

    public ModelVersion getVersion() {
        return VERSION;
    }

    public void migrate(KeycloakSession session) {
        RealmModel sessionRealm = session.getContext().getRealm();
        session.realms().getRealmsStream().forEach(realm -> {
            session.getContext().setRealm(realm);
            this.migrateRealm(session, (RealmModel)realm);
        });
        session.getContext().setRealm(sessionRealm);
    }

    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        RealmModel sessionRealm = session.getContext().getRealm();
        session.getContext().setRealm(realm);
        this.migrateRealm(session, realm);
        session.getContext().setRealm(sessionRealm);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm) {
        realm.setAccessTokenLifespanForImplicitFlow(900);
        MigrationProvider migrationProvider = (MigrationProvider)session.getProvider(MigrationProvider.class);
        migrationProvider.setupAdminCli(realm);
        DefaultAuthenticationFlows.migrateFlows((RealmModel)realm);
        AuthenticationFlowModel firstBrokerLoginFlow = realm.getFlowByAlias("first broker login");
        session.identityProviders().getAllStream(Map.of("firstBrokerLoginFlowId", ""), null, null).forEach(provider -> {
            provider.setFirstBrokerLoginFlowId(firstBrokerLoginFlow.getId());
            session.identityProviders().update(provider);
        });
    }
}

