/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal;

import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.SecondLevelCacheLogger;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class CollectionCacheInvalidator
implements Integrator,
PostInsertEventListener,
PostDeleteEventListener,
PostUpdateEventListener {
    private static final Logger LOG = Logger.getLogger((String)CollectionCacheInvalidator.class.getName());
    public static boolean PROPAGATE_EXCEPTION = false;

    @Override
    public void integrate(Metadata metadata, BootstrapContext bootstrapContext, SessionFactoryImplementor sessionFactory) {
        this.integrate(sessionFactory);
    }

    @Override
    public void onPostInsert(PostInsertEvent event) {
        this.evictCache(event.getEntity(), event.getPersister(), event.getSession(), null);
    }

    @Override
    public boolean requiresPostCommitHandling(EntityPersister persister) {
        return true;
    }

    @Override
    public void onPostDelete(PostDeleteEvent event) {
        this.evictCache(event.getEntity(), event.getPersister(), event.getSession(), null);
    }

    @Override
    public void onPostUpdate(PostUpdateEvent event) {
        this.evictCache(event.getEntity(), event.getPersister(), event.getSession(), event.getOldState());
    }

    private void integrate(SessionFactoryImplementor sessionFactory) {
        SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
        if (!sessionFactoryOptions.isAutoEvictCollectionCache()) {
            return;
        }
        if (!sessionFactoryOptions.isSecondLevelCacheEnabled()) {
            return;
        }
        EventListenerRegistry eventListenerRegistry = sessionFactory.getEventListenerRegistry();
        eventListenerRegistry.appendListeners(EventType.POST_INSERT, this);
        eventListenerRegistry.appendListeners(EventType.POST_DELETE, this);
        eventListenerRegistry.appendListeners(EventType.POST_UPDATE, this);
    }

    private void evictCache(Object entity, EntityPersister persister, EventSource session, Object[] oldState) {
        try {
            MappingMetamodelImplementor metamodel = persister.getFactory().getMappingMetamodel();
            Set<String> roles = metamodel.getCollectionRolesByEntityParticipant(persister.getEntityName());
            if (!CollectionHelper.isEmpty(roles)) {
                for (String role : roles) {
                    this.evictCollection(entity, persister, oldState, metamodel.getCollectionDescriptor(role), session);
                }
            }
        }
        catch (Exception e) {
            if (PROPAGATE_EXCEPTION) {
                throw new IllegalStateException(e);
            }
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private void evictCollection(Object entity, EntityPersister persister, Object[] oldState, CollectionPersister collectionPersister, EventSource session) {
        if (collectionPersister.hasCache()) {
            if (CollectionCacheInvalidator.isInverseOneToMany(collectionPersister)) {
                this.handleInverseOneToMany(entity, persister, oldState, collectionPersister, session);
            } else {
                if (SecondLevelCacheLogger.L2CACHE_LOGGER.isTraceEnabled()) {
                    SecondLevelCacheLogger.L2CACHE_LOGGER.autoEvictingCollectionCacheByRole(collectionPersister.getRole());
                }
                CollectionDataAccess cacheAccessStrategy = collectionPersister.getCacheAccessStrategy();
                SoftLock softLock = cacheAccessStrategy.lockRegion();
                session.getActionQueue().registerProcess((success, s) -> cacheAccessStrategy.unlockRegion(softLock));
            }
        }
    }

    private void handleInverseOneToMany(Object entity, EntityPersister persister, Object[] oldState, CollectionPersister collectionPersister, EventSource session) {
        int propertyIndex = persister.getPropertyIndex(collectionPersister.getMappedByProperty());
        Object oldId = oldState == null ? null : this.getIdentifier(session, oldState[propertyIndex]);
        Object currentId = this.getIdentifier(session, persister.getValue(entity, propertyIndex));
        if (!(currentId == null && oldId == null || collectionPersister.getKeyType().isEqual(oldId, currentId))) {
            if (currentId != null) {
                this.evict(currentId, collectionPersister, session);
            }
            if (oldId != null) {
                this.evict(oldId, collectionPersister, session);
            }
        }
    }

    private static boolean isInverseOneToMany(CollectionPersister collectionPersister) {
        return collectionPersister.isOneToMany() && !StringHelper.isEmpty(collectionPersister.getMappedByProperty());
    }

    private Object getIdentifier(SharedSessionContractImplementor session, Object object) {
        if (object != null) {
            Object id = session.getContextEntityIdentifier(object);
            if (id == null) {
                return session.getFactory().getMappingMetamodel().getEntityDescriptor(object.getClass()).getIdentifier(object, session);
            }
            return id;
        }
        return null;
    }

    private void evict(Object id, CollectionPersister collectionPersister, EventSource session) {
        if (SecondLevelCacheLogger.L2CACHE_LOGGER.isTraceEnabled()) {
            SecondLevelCacheLogger.L2CACHE_LOGGER.autoEvictingCollectionCache(MessageHelper.collectionInfoString(collectionPersister, id, collectionPersister.getFactory()));
        }
        CollectionEvictCacheAction evictCacheAction = new CollectionEvictCacheAction(collectionPersister, null, id, session);
        evictCacheAction.execute();
        session.getActionQueue().registerProcess(evictCacheAction.getAfterTransactionCompletionProcess());
    }

    private static final class CollectionEvictCacheAction
    extends CollectionAction {
        CollectionEvictCacheAction(CollectionPersister persister, PersistentCollection<?> collection, Object key, EventSource session) {
            super(persister, collection, key, session);
        }

        @Override
        public void execute() throws HibernateException {
            this.beforeExecutions();
            this.evict();
        }
    }
}

