/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayIntersectsFunction;
import org.hibernate.dialect.function.array.ArrayHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class H2ArrayIntersectsFunction
extends AbstractArrayIntersectsFunction {
    private final int maximumArraySize;

    public H2ArrayIntersectsFunction(boolean nullable, int maximumArraySize, TypeConfiguration typeConfiguration) {
        super(nullable, typeConfiguration);
        this.maximumArraySize = maximumArraySize;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression haystackExpression = (Expression)sqlAstArguments.get(0);
        Expression needleExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append('(');
        if (ArrayHelper.isNullable(haystackExpression)) {
            haystackExpression.accept(walker);
            sqlAppender.append(" is not null and ");
        }
        if (ArrayHelper.isNullable(needleExpression)) {
            needleExpression.accept(walker);
            sqlAppender.append(" is not null and ");
        }
        if (!this.nullable) {
            sqlAppender.append("not array_contains(");
            needleExpression.accept(walker);
            sqlAppender.append(",null) and ");
        }
        sqlAppender.append("exists(select array_get(");
        needleExpression.accept(walker);
        sqlAppender.append(",t.i) from system_range(1,");
        sqlAppender.append(Integer.toString(this.maximumArraySize));
        sqlAppender.append(") t(i) where array_length(");
        needleExpression.accept(walker);
        sqlAppender.append(")>=t.i");
        sqlAppender.append(" intersect ");
        sqlAppender.append("select array_get(");
        haystackExpression.accept(walker);
        sqlAppender.append(",t.i) from system_range(1,");
        sqlAppender.append(Integer.toString(this.maximumArraySize));
        sqlAppender.append(") t(i) where array_length(");
        haystackExpression.accept(walker);
        sqlAppender.append(")>=t.i))");
    }
}

