/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.util.regex.Pattern;
import org.hibernate.dialect.pagination.AbstractSimpleLimitHandler;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class LimitLimitHandler
extends AbstractSimpleLimitHandler {
    public static final LimitLimitHandler INSTANCE = new LimitLimitHandler();
    private static final Pattern FOR_UPDATE_PATTERN = Pattern.compile("\\s+for\\s+update\\b|\\s+lock\\s+in\\s+shared\\s+mode\\b|\\s*;?\\s*$", 2);

    @Override
    protected String limitClause(boolean hasFirstRow) {
        return hasFirstRow ? " limit ?,?" : " limit ?";
    }

    @Override
    protected String limitClause(boolean hasFirstRow, int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        String firstParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
        if (hasFirstRow) {
            return " limit " + firstParameter + "," + parameterMarkerStrategy.createMarker(jdbcParameterCount + 2, null);
        }
        return " limit " + firstParameter;
    }

    @Override
    protected String offsetOnlyClause() {
        return " limit ?,2147483647";
    }

    @Override
    protected String offsetOnlyClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " limit " + parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null) + ",2147483647";
    }

    @Override
    protected Pattern getForUpdatePattern() {
        return FOR_UPDATE_PATTERN;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean processSqlMutatesState() {
        return false;
    }
}

