/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.internal.LobCreationLogging;
import org.hibernate.engine.jdbc.env.internal.LobTypes;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class LobCreationHelper {
    public static final EnumSet<LobTypes> NONE = EnumSet.noneOf(LobTypes.class);

    public static EnumSet<LobTypes> getSupportedContextualLobTypes(Dialect dialect, Map<String, Object> configValues, Connection jdbcConnection) {
        if (ConfigurationHelper.getBoolean("hibernate.jdbc.lob.non_contextual_creation", configValues)) {
            LobCreationLogging.LOB_MESSAGE_LOGGER.disablingContextualLOBCreation("hibernate.jdbc.lob.non_contextual_creation");
            return NONE;
        }
        if (jdbcConnection == null) {
            LobCreationLogging.LOB_MESSAGE_LOGGER.disablingContextualLOBCreationSinceConnectionNull();
            return NONE;
        }
        try {
            DatabaseMetaData meta = jdbcConnection.getMetaData();
            if (meta.getJDBCMajorVersion() < 4) {
                LobCreationLogging.LOB_MESSAGE_LOGGER.nonContextualLobCreationJdbcVersion(meta.getJDBCMajorVersion());
                return NONE;
            }
            if (!dialect.supportsJdbcConnectionLobCreation(meta)) {
                LobCreationLogging.LOB_MESSAGE_LOGGER.nonContextualLobCreationDialect();
                return NONE;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (LobCreationHelper.canCreateClob(jdbcConnection)) {
            if (LobCreationHelper.canCreateNClob(jdbcConnection)) {
                return EnumSet.of(LobTypes.BLOB, LobTypes.CLOB, LobTypes.NCLOB);
            }
            return EnumSet.of(LobTypes.BLOB, LobTypes.CLOB);
        }
        return NONE;
    }

    private static boolean canCreateClob(Connection jdbcConnection) {
        try {
            Clob clob = jdbcConnection.createClob();
            try {
                clob.free();
            }
            catch (Throwable e) {
                LobCreationLogging.LOB_LOGGER.tracef("Unable to free CLOB created to test createClob() implementation: %s", (Object)e);
            }
            return true;
        }
        catch (SQLException e) {
            LobCreationLogging.LOB_MESSAGE_LOGGER.contextualClobCreationFailed(e);
            return false;
        }
    }

    private static boolean canCreateNClob(Connection jdbcConnection) {
        try {
            NClob clob = jdbcConnection.createNClob();
            try {
                clob.free();
            }
            catch (Throwable e) {
                LobCreationLogging.LOB_LOGGER.tracef("Unable to free NCLOB created to test createNClob() implementation: %s", (Object)e);
            }
            return true;
        }
        catch (SQLException e) {
            LobCreationLogging.LOB_MESSAGE_LOGGER.contextualNClobCreationFailed(e);
            return false;
        }
    }
}

