/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractMultiNaturalIdLoader;
import org.hibernate.loader.ast.internal.MultiNaturalIdLoadingBatcher;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoadOptions;
import org.hibernate.loader.ast.spi.SqlInPredicateMultiKeyLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;

public class MultiNaturalIdLoaderInPredicate<E>
extends AbstractMultiNaturalIdLoader<E>
implements SqlInPredicateMultiKeyLoader {
    public MultiNaturalIdLoaderInPredicate(EntityMappingType entityDescriptor) {
        super(entityDescriptor);
    }

    @Override
    public List<E> loadEntitiesWithUnresolvedIds(Object[] naturalIds, MultiNaturalIdLoadOptions loadOptions, LockOptions lockOptions, SharedSessionContractImplementor session) {
        return this.getBatcher(naturalIds, loadOptions, lockOptions, session).multiLoad(naturalIds, session);
    }

    private MultiNaturalIdLoadingBatcher getBatcher(Object[] naturalIds, MultiNaturalIdLoadOptions loadOptions, LockOptions lockOptions, SharedSessionContractImplementor session) {
        EntityMappingType descriptor = this.getEntityDescriptor();
        return new MultiNaturalIdLoadingBatcher(descriptor, descriptor.getNaturalIdMapping(), Math.min(naturalIds.length, this.getMaxBatchSize(naturalIds, loadOptions, session)), (naturalId, s) -> descriptor.getNaturalIdMapping().normalizeInput(naturalId), session.getLoadQueryInfluencers(), lockOptions, session.getFactory());
    }

    private int getMaxBatchSize(Object[] naturalIds, MultiNaturalIdLoadOptions loadOptions, SharedSessionContractImplementor session) {
        Integer batchSize = loadOptions.getBatchSize();
        if (batchSize != null && batchSize > 0) {
            return batchSize;
        }
        return session.getJdbcServices().getJdbcEnvironment().getDialect().getMultiKeyLoadSizingStrategy().determineOptimalBatchLoadSize(this.getEntityDescriptor().getNaturalIdMapping().getJdbcTypeCount(), naturalIds.length, session.getFactory().getSessionFactoryOptions().inClauseParameterPaddingEnabled());
    }
}

