/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.internal.AbstractCompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.AggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class EmbeddedIdentifierMappingImpl
extends AbstractCompositeIdentifierMapping
implements AggregatedIdentifierMapping {
    private final String name;
    private final EmbeddableMappingType embeddableDescriptor;
    private final PropertyAccess propertyAccess;

    public EmbeddedIdentifierMappingImpl(EntityMappingType entityMapping, String name, EmbeddableMappingType embeddableDescriptor, PropertyAccess propertyAccess, String tableExpression, MappingModelCreationProcess creationProcess) {
        super(entityMapping, tableExpression, creationProcess);
        this.name = name;
        this.embeddableDescriptor = embeddableDescriptor;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public String getPartName() {
        return this.name;
    }

    @Override
    public EntityIdentifierMapping.Nature getNature() {
        return EntityIdentifierMapping.Nature.COMPOSITE;
    }

    @Override
    public EmbeddableMappingType getPartMappingType() {
        return this.embeddableDescriptor;
    }

    @Override
    public EmbeddableMappingType getMappedIdEmbeddableTypeDescriptor() {
        return this.getMappedType();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.getEmbeddableTypeDescriptor().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.getEmbeddableTypeDescriptor().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public Object getIdentifier(Object entity) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(entity);
        if (lazyInitializer != null) {
            return lazyInitializer.getInternalIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.propertyAccess.getSetter().set(entity, id);
    }

    @Override
    public String getSqlAliasStem() {
        return this.name;
    }

    @Override
    public String getFetchableName() {
        return this.name;
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public int compare(Object value1, Object value2) {
        return this.getEmbeddableTypeDescriptor().compare(value1, value2);
    }
}

