/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import org.hibernate.mapping.Collection;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.persister.spi.UnknownPersisterException;

public class StandardPersisterClassResolver
implements PersisterClassResolver {
    @Override
    public Class<? extends EntityPersister> getEntityPersisterClass(PersistentClass model) {
        if (model instanceof RootClass) {
            if (model.hasSubclasses()) {
                model = model.getDirectSubclasses().get(0);
            } else {
                return this.singleTableEntityPersister();
            }
        }
        if (model instanceof JoinedSubclass) {
            return this.joinedSubclassEntityPersister();
        }
        if (model instanceof UnionSubclass) {
            return this.unionSubclassEntityPersister();
        }
        if (model instanceof SingleTableSubclass) {
            return this.singleTableEntityPersister();
        }
        throw new UnknownPersisterException("Could not determine persister implementation for entity [" + model.getEntityName() + "]");
    }

    public Class<? extends EntityPersister> singleTableEntityPersister() {
        return SingleTableEntityPersister.class;
    }

    public Class<? extends EntityPersister> joinedSubclassEntityPersister() {
        return JoinedSubclassEntityPersister.class;
    }

    public Class<? extends EntityPersister> unionSubclassEntityPersister() {
        return UnionSubclassEntityPersister.class;
    }

    @Override
    public Class<? extends CollectionPersister> getCollectionPersisterClass(Collection metadata) {
        return metadata.isOneToMany() ? this.oneToManyPersister() : this.basicCollectionPersister();
    }

    private Class<OneToManyPersister> oneToManyPersister() {
        return OneToManyPersister.class;
    }

    private Class<BasicCollectionPersister> basicCollectionPersister() {
        return BasicCollectionPersister.class;
    }
}

