/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.spi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.Incubating;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;

public interface JdbcSessionOwner {
    public JdbcSessionContext getJdbcSessionContext();

    public JdbcConnectionAccess getJdbcConnectionAccess();

    public TransactionCoordinator getTransactionCoordinator();

    public void startTransactionBoundary();

    public void afterTransactionBegin();

    public void beforeTransactionCompletion();

    public void afterTransactionCompletion(boolean var1, boolean var2);

    public void flushBeforeTransactionCompletion();

    public Integer getJdbcBatchSize();

    default public SqlExceptionHelper getSqlExceptionHelper() {
        return this.getJdbcSessionContext().getJdbcServices().getSqlExceptionHelper();
    }

    @Incubating
    public void afterObtainConnection(Connection var1) throws SQLException;

    @Incubating
    public void beforeReleaseConnection(Connection var1) throws SQLException;

    public EventMonitor getEventMonitor();

    @Deprecated(since="7.0", forRemoval=true)
    default public EventManager getEventManager() {
        EventMonitor eventMonitor = this.getEventMonitor();
        return (EventManager)Proxy.newProxyInstance(EventManager.class.getClassLoader(), new Class[]{EventManager.class}, (instance, method, arguments) -> InvocationHandler.invokeDefault(eventMonitor, method, arguments));
    }
}

