/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.workflow.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowProvider;
import org.keycloak.representations.workflows.WorkflowRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.workflow.admin.resource.WorkflowResource;

@Extension(name="x-smallrye-profile-admin", value="")
public class WorkflowsResource {
    private final KeycloakSession session;
    private final WorkflowProvider provider;
    private final AdminPermissionEvaluator auth;

    public WorkflowsResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.WORKFLOWS)) {
            throw new NotFoundException();
        }
        this.session = session;
        this.provider = (WorkflowProvider)session.getProvider(WorkflowProvider.class);
        this.auth = auth;
    }

    @POST
    @Consumes(value={"application/yaml", "application/json"})
    @Tag(name="Workflows")
    @Operation(summary="Create workflow", description="Create a new workflow from the provided representation.")
    @APIResponses(value={@APIResponse(responseCode="201", description="Created"), @APIResponse(responseCode="400", description="Bad Request")})
    public Response create(WorkflowRepresentation rep) {
        this.auth.realm().requireManageRealm();
        try {
            Workflow workflow = this.provider.toModel(rep);
            return Response.created((URI)this.session.getContext().getUri().getRequestUriBuilder().path(workflow.getId()).build(new Object[0])).build();
        }
        catch (ModelException me) {
            throw ErrorResponse.error(me.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="{id}")
    @Tag(name="Workflows")
    @Operation(summary="Get workflow sub-resource", description="Locate the workflow sub-resource for the given identifier.")
    @APIResponses(value={@APIResponse(responseCode="200", description="Workflow sub-resource located"), @APIResponse(responseCode="404", description="Not Found")})
    public WorkflowResource get(@Parameter(description="Workflow identifier") @PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        Workflow workflow = this.provider.getWorkflow(id);
        if (workflow == null) {
            throw new NotFoundException("Workflow with id " + id + " not found");
        }
        return new WorkflowResource(this.provider, workflow);
    }

    @GET
    @Produces(value={"application/yaml", "application/json"})
    @Tag(name="Workflows")
    @Operation(summary="List workflows", description="List workflows filtered by name and paginated using first and max parameters.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=WorkflowRepresentation.class))}), @APIResponse(responseCode="400", description="Bad Request")})
    public List<WorkflowRepresentation> list(@Parameter(description="A String representing the workflow name - either partial or exact") @QueryParam(value="search") String search, @Parameter(description="Boolean which defines whether the param 'search' must match exactly or not") @QueryParam(value="exact") Boolean exact, @Parameter(description="The position of the first result to be processed (pagination offset)") @QueryParam(value="first") @DefaultValue(value="0") Integer firstResult, @Parameter(description="The maximum number of results to be returned - defaults to 10") @QueryParam(value="max") @DefaultValue(value="10") Integer maxResults) {
        this.auth.realm().requireManageRealm();
        int first = Optional.ofNullable(firstResult).orElse(0);
        int max = Optional.ofNullable(maxResults).orElse(10);
        return this.provider.getWorkflows(search, exact, Integer.valueOf(first), Integer.valueOf(max)).map(arg_0 -> ((WorkflowProvider)this.provider).toRepresentation(arg_0)).toList();
    }

    @Path(value="scheduled/{resource-id}")
    @GET
    @Produces(value={"application/json"})
    @Tag(name="Workflows")
    @Operation(summary="List scheduled workflows for resource", description="Return workflows that have scheduled steps for the given resource identifier.")
    @APIResponses(value={@APIResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=WorkflowRepresentation.class))}), @APIResponse(responseCode="400", description="Bad Request")})
    public List<WorkflowRepresentation> getScheduledSteps(@Parameter(description="Identifier of the resource associated with the scheduled workflows") @PathParam(value="resource-id") String resourceId) {
        this.auth.realm().requireManageRealm();
        return this.provider.getScheduledWorkflowsByResource(resourceId).toList();
    }
}

